/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.attachment;

import java.util.Collection;
import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.core.skin.attachment.SkinAttachmentType;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModLog;
import org.apache.commons.lang3.tuple.Pair;

public class SkinAttachmentTypes {
    private static final LinkedHashMap<String, SkinAttachmentType> ALL_ATTACHMENT_TYPES = new LinkedHashMap();
    public static final SkinAttachmentType UNKNOWN = SkinAttachmentTypes.register("unknown");
    public static final SkinAttachmentType LEFT_HAND = SkinAttachmentTypes.register("leftHand");
    public static final SkinAttachmentType RIGHT_HAND = SkinAttachmentTypes.register("rightHand");
    public static final SkinAttachmentType LEFT_SHOULDER = SkinAttachmentTypes.register("leftShoulder");
    public static final SkinAttachmentType RIGHT_SHOULDER = SkinAttachmentTypes.register("rightShoulder");
    public static final SkinAttachmentType ELYTRA = SkinAttachmentTypes.register("elytra");
    public static final SkinAttachmentType NAME = SkinAttachmentTypes.register("name");
    public static final SkinAttachmentType RIDING = SkinAttachmentTypes.register("riding");
    public static final SkinAttachmentType LEFT_WAIST = SkinAttachmentTypes.register("leftWaist");
    public static final SkinAttachmentType RIGHT_WAIST = SkinAttachmentTypes.register("rightWaist");
    public static final SkinAttachmentType BACKPACK = SkinAttachmentTypes.register("backpack");
    public static final SkinAttachmentType VIEW = SkinAttachmentTypes.register("view");

    private static SkinAttachmentType register(String name) {
        SkinAttachmentType attachmentType = new SkinAttachmentType();
        attachmentType.setRegistryName(OpenResourceLocation.create("armourers", name));
        if (ALL_ATTACHMENT_TYPES.containsKey(attachmentType.getRegistryName().toString())) {
            ModLog.warn("A mod tried to register a attachment type with an id that is in use.", new Object[0]);
            return attachmentType;
        }
        ALL_ATTACHMENT_TYPES.put(attachmentType.getRegistryName().toString(), attachmentType);
        ModLog.debug("Registering Skin Attachment '{}'", attachmentType.getRegistryName());
        return attachmentType;
    }

    public static SkinAttachmentType byName(String name) {
        if (name.equals("hand_l")) {
            return LEFT_HAND;
        }
        if (name.equals("hand_r")) {
            return RIGHT_HAND;
        }
        return ALL_ATTACHMENT_TYPES.getOrDefault(name, UNKNOWN);
    }

    public static Pair<SkinAttachmentType, Integer> parse(String name) {
        String index = name.replaceFirst("^.+?(?:\\.(\\d+))?$", "$1");
        if (index.isEmpty()) {
            return Pair.of((Object)SkinAttachmentTypes.byName(name), (Object)-1);
        }
        name = name.replaceFirst("\\.\\d+$", "");
        return Pair.of((Object)SkinAttachmentTypes.byName(name), (Object)Integer.parseInt(index));
    }

    public static Collection<SkinAttachmentType> values() {
        return ALL_ATTACHMENT_TYPES.values();
    }
}

