/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.ISkin;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.SkinPreviewData;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.property.SkinSettings;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import moe.plushie.armourers_workshop.core.utils.OpenRandomSource;
import org.jetbrains.annotations.Nullable;

public class Skin
implements ISkin {
    private final int id;
    private final int version;
    private final SkinSettings settings;
    private final SkinProperties properties;
    private final SkinType type;
    private final List<SkinPart> parts;
    private final List<SkinAnimation> animations;
    private final SkinPaintData paintData;
    private final SkinPreviewData previewData;
    private final Object blobs;
    private Map<OpenVector3i, OpenRectangle3f> blockBounds;

    protected Skin(int id, int version, SkinType type, SkinProperties properties, SkinSettings settings, SkinPaintData paintData, SkinPreviewData previewData, List<SkinAnimation> animations, List<SkinPart> parts, Object blobs) {
        this.id = id;
        this.version = version;
        this.type = type;
        this.properties = properties;
        this.settings = settings;
        this.blobs = blobs;
        this.paintData = paintData;
        this.previewData = previewData;
        this.animations = new ArrayList<SkinAnimation>(animations);
        this.parts = new ArrayList<SkinPart>(parts);
    }

    public int getId() {
        return this.id;
    }

    public SkinSettings getSettings() {
        return this.settings;
    }

    public SkinProperties getProperties() {
        return this.properties;
    }

    public Map<OpenVector3i, OpenRectangle3f> getBlockBounds() {
        if (this.blockBounds != null) {
            return this.blockBounds;
        }
        this.blockBounds = new HashMap<OpenVector3i, OpenRectangle3f>();
        if (this.type != SkinTypes.BLOCK) {
            return this.blockBounds;
        }
        List<OpenRectangle3f> collisionBox = this.settings.getCollisionBox();
        this.blockBounds.put(OpenVector3i.ZERO, OpenRectangle3f.ZERO);
        if (collisionBox != null) {
            for (OpenRectangle3f rect : collisionBox) {
                OpenRectangle3i rect1 = new OpenRectangle3i(rect);
                int bx = -Math.floorDiv(rect1.minX(), 16);
                int by = -Math.floorDiv(rect1.minY(), 16);
                int bz = Math.floorDiv(rect1.minZ(), 16);
                int tx = Math.floorMod(rect1.minX(), 16) - 8;
                int ty = Math.floorMod(rect1.minY(), 16) - 8;
                int tz = Math.floorMod(rect1.minZ(), 16) - 8;
                int tw = rect1.width();
                int th = rect1.height();
                int td = rect1.depth();
                this.blockBounds.put(new OpenVector3i(bx, by, bz), new OpenRectangle3f(-tx, -ty, tz, -tw, -th, td));
            }
            return this.blockBounds;
        }
        for (SkinPart part : this.getParts()) {
            Map<OpenVector3i, OpenRectangle3f> partBlockBounds = part.getBlockBounds();
            if (partBlockBounds == null) continue;
            this.blockBounds.putAll(partBlockBounds);
        }
        return this.blockBounds;
    }

    public int getModelCount() {
        int count = 0;
        for (SkinPart part : this.parts) {
            count += part.getModelCount();
        }
        return count;
    }

    public int getPartCount() {
        return this.parts.size();
    }

    @Override
    public SkinType getType() {
        return this.type;
    }

    @Nullable
    public SkinPaintData getPaintData() {
        return this.paintData;
    }

    public SkinPreviewData getPreviewData() {
        return this.previewData;
    }

    public List<SkinPart> getParts() {
        return this.parts;
    }

    public List<SkinAnimation> getAnimations() {
        return this.animations;
    }

    public OpenItemTransforms getItemTransforms() {
        return this.settings.getItemTransforms();
    }

    public String getCustomName() {
        return this.properties.get(SkinProperty.ALL_CUSTOM_NAME);
    }

    public String getAuthorName() {
        return this.properties.get(SkinProperty.ALL_AUTHOR_NAME);
    }

    public String getAuthorUUID() {
        return this.properties.get(SkinProperty.ALL_AUTHOR_UUID);
    }

    public String getFlavourText() {
        return this.properties.get(SkinProperty.ALL_FLAVOUR_TEXT);
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return Objects.toString(this, "type", this.type.getRegistryName().toString(), "properties", this.properties, "settings", this.settings, "animations", this.animations, "paintData", this.paintData, "previewData", this.previewData);
    }

    public List<SkinMarker> getMarkers() {
        ArrayList<SkinMarker> markers = new ArrayList<SkinMarker>();
        for (SkinPart part : this.parts) {
            markers.addAll(part.getMarkers());
        }
        return markers;
    }

    public Object getBlobs() {
        return this.blobs;
    }

    public static class Builder {
        private final SkinType type;
        private ArrayList<SkinPart> skinParts = new ArrayList();
        private ArrayList<SkinAnimation> animations = new ArrayList();
        private SkinPaintData paintData;
        private SkinPreviewData previewData;
        private SkinSettings settings = new SkinSettings();
        private SkinProperties properties = SkinProperties.EMPTY;
        private Object blobs;
        private int id = -1;
        private int version = 13;

        public Builder(SkinType type) {
            this.type = type;
            if (type == SkinTypes.OUTFIT) {
                this.settings.setEditable(false);
            }
        }

        public static int generateId() {
            return OpenRandomSource.nextInt(Skin.class);
        }

        public Builder properties(SkinProperties properties) {
            if (properties != null) {
                this.properties = properties;
            }
            return this;
        }

        public Builder settings(SkinSettings settings) {
            if (settings != null) {
                this.settings = settings;
            }
            return this;
        }

        public Builder paintData(SkinPaintData paintData) {
            this.paintData = paintData;
            return this;
        }

        public Builder previewData(SkinPreviewData previewData) {
            this.previewData = previewData;
            return this;
        }

        public Builder parts(List<SkinPart> parts) {
            if (parts != null) {
                this.skinParts = new ArrayList<SkinPart>(parts);
            }
            return this;
        }

        public Builder animations(List<SkinAnimation> animations) {
            if (animations != null) {
                this.animations = new ArrayList<SkinAnimation>(animations);
            }
            return this;
        }

        public Builder blobs(Object blobs) {
            this.blobs = blobs;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Skin build() {
            this.updateIdIfNeeded();
            this.updateSettingIfNeeded();
            this.updatePropertiesIfNeeded();
            return new Skin(this.id, this.version, this.type, this.properties, this.settings, this.paintData, this.previewData, this.animations, this.skinParts, this.blobs);
        }

        private void updateIdIfNeeded() {
            if (this.id == -1) {
                this.id = Builder.generateId();
            }
        }

        private void updateSettingIfNeeded() {
            this.settings.setPreviewMode(this.previewData != null && this.skinParts.isEmpty());
        }

        private void updatePropertiesIfNeeded() {
            String skinIndexes;
            if (this.properties.get(SkinProperty.OVERRIDE_MODEL_ALL).booleanValue()) {
                if (this.type == SkinTypes.ARMOR_HEAD) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_HEAD, true);
                }
                if (this.type == SkinTypes.ARMOR_CHEST) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_CHEST, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_LEFT_ARM, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, true);
                }
                if (this.type == SkinTypes.ARMOR_LEGS) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, true);
                }
                if (this.type == SkinTypes.ARMOR_FEET) {
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, true);
                    this.properties.put(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, true);
                }
                this.properties.remove(SkinProperty.OVERRIDE_MODEL_ALL);
            }
            if (this.properties.get(SkinProperty.OVERRIDE_OVERLAY_ALL).booleanValue()) {
                if (this.type == SkinTypes.ARMOR_HEAD) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_HAT, true);
                }
                if (this.type == SkinTypes.ARMOR_CHEST) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_JACKET, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE, true);
                }
                if (this.type == SkinTypes.ARMOR_LEGS) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, true);
                }
                if (this.type == SkinTypes.ARMOR_FEET) {
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS, true);
                    this.properties.put(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS, true);
                }
                this.properties.remove(SkinProperty.OVERRIDE_OVERLAY_ALL);
            }
            if (!this.properties.get(SkinProperty.OVERRIDE_OVERLAY_COLOR).booleanValue()) {
                this.properties.put(SkinProperty.USE_OVERLAY_COLOR, true);
                this.properties.remove(SkinProperty.OVERRIDE_OVERLAY_COLOR);
            }
            if (this.type == SkinTypes.ARMOR_WINGS) {
                this.skinParts.forEach(it -> it.setProperties(this.properties.slice("")));
            }
            if ((skinIndexes = this.properties.get(SkinProperty.OUTFIT_PART_INDEXS)) != null && !skinIndexes.isEmpty()) {
                String[] split = skinIndexes.split(":");
                int partIndex = 0;
                for (int skinIndex = 0; skinIndex < split.length; ++skinIndex) {
                    SkinProperties stub = this.properties.slice(String.valueOf(skinIndex));
                    int count = Integer.parseInt(split[skinIndex]);
                    while (partIndex < count) {
                        if (partIndex < this.skinParts.size()) {
                            SkinPart skinPart = this.skinParts.get(partIndex);
                            skinPart.setProperties(stub);
                        }
                        ++partIndex;
                    }
                    partIndex = count;
                }
            }
        }
    }
}

