/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.client.animation.AnimationManager;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class UpdateAnimationPacket
extends CustomPacket {
    private final Mode mode;
    private final CompoundTag value;

    public UpdateAnimationPacket(Mode mode, CompoundTag value) {
        this.mode = mode;
        this.value = value;
    }

    public UpdateAnimationPacket(IFriendlyByteBuf buffer) {
        this.mode = buffer.readEnum(Mode.class);
        this.value = buffer.readNbt();
    }

    public static UpdateAnimationPacket play(Selector selector, String name, CompoundTag properties) {
        CompoundTag tag = selector.save();
        tag.m_128359_("name", name);
        tag.m_128365_("properties", (Tag)properties);
        return new UpdateAnimationPacket(Mode.PLAY, tag);
    }

    public static UpdateAnimationPacket stop(Selector selector, String name) {
        CompoundTag tag = selector.save();
        tag.m_128359_("name", name);
        return new UpdateAnimationPacket(Mode.STOP, tag);
    }

    public static UpdateAnimationPacket rewrite(Selector selector, String from, String to) {
        CompoundTag tag = selector.save();
        tag.m_128359_("from", from);
        tag.m_128359_("to", to);
        return new UpdateAnimationPacket(Mode.MAPPING, tag);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum(this.mode);
        buffer.writeNbt(this.value);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        switch (this.mode.ordinal()) {
            case 0: {
                AnimationManager animationManager = this.getTargetRenderData(player);
                if (animationManager == null) break;
                String name = this.value.m_128461_("name");
                CompoundTag properties = this.value.m_128469_("properties");
                ModLog.debug("play animation {}", this.value);
                animationManager.play(name, TickUtils.animationTicks(), properties);
                break;
            }
            case 1: {
                AnimationManager animationManager = this.getTargetRenderData(player);
                if (animationManager == null) break;
                String name = this.value.m_128461_("name");
                ModLog.debug("stop animation {}", this.value);
                animationManager.stop(name);
                break;
            }
            case 2: {
                AnimationManager animationManager = this.getTargetRenderData(player);
                if (animationManager == null) break;
                String from = this.value.m_128461_("from");
                String to = this.value.m_128461_("to");
                ModLog.debug("rewrite animation {} to {}", from, to);
                animationManager.map(from, to);
                break;
            }
        }
    }

    private AnimationManager getTargetRenderData(Player player) {
        if (this.value.m_128441_("entity")) {
            int entityId = this.value.m_128451_("entity");
            return AnimationManager.of(PropertyProvider.getLevel((Entity)player).m_6815_(entityId));
        }
        if (this.value.m_128441_("block")) {
            BlockPos blockPos = BlockPos.m_122022_((long)this.value.m_128454_("block"));
            return AnimationManager.of(PropertyProvider.getLevel((Entity)player).m_7702_(blockPos));
        }
        return null;
    }

    public static enum Mode {
        PLAY,
        STOP,
        MAPPING,
        MODERATOR;

    }

    public static class Selector {
        private final int id;
        private final BlockPos pos;

        public Selector(Entity entity) {
            this.id = entity.m_19879_();
            this.pos = null;
        }

        public Selector(BlockPos blockPos) {
            this.id = -1;
            this.pos = blockPos;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            if (this.pos != null) {
                tag.m_128356_("block", this.pos.m_121878_());
            } else {
                tag.m_128405_("entity", this.id);
            }
            return tag;
        }
    }
}

