/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.core.math.IVector3f;
import moe.plushie.armourers_workshop.api.core.math.IVoxelShape;
import moe.plushie.armourers_workshop.core.math.OpenAxisAlignedBoundingBox;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.utils.Collections;

public class OpenVoxelShape
implements IVoxelShape,
Iterable<OpenVector4f> {
    private OpenAxisAlignedBoundingBox aabb;
    private OpenRectangle3f box;
    private List<OpenVector4f> vertexes;

    public static OpenVoxelShape empty() {
        return new OpenVoxelShape();
    }

    public static OpenVoxelShape box(IRectangle3f bounds) {
        if (bounds instanceof OpenRectangle3f) {
            OpenRectangle3f rect = (OpenRectangle3f)bounds;
            return OpenVoxelShape.box(rect);
        }
        return OpenVoxelShape.box(new OpenRectangle3f(bounds));
    }

    public static OpenVoxelShape box(IRectangle3i bounds) {
        return OpenVoxelShape.box(new OpenRectangle3f(bounds));
    }

    public static OpenVoxelShape box(OpenRectangle3f bounds) {
        OpenVoxelShape shape = new OpenVoxelShape();
        shape.box = bounds;
        return shape;
    }

    public OpenAxisAlignedBoundingBox aabb() {
        if (this.aabb != null) {
            return this.aabb;
        }
        this.aabb = new OpenAxisAlignedBoundingBox(this.bounds());
        return this.aabb;
    }

    public OpenRectangle3f bounds() {
        if (this.box != null) {
            return this.box;
        }
        if (this.vertexes == null || this.vertexes.isEmpty()) {
            return OpenRectangle3f.ZERO;
        }
        Iterator<OpenVector4f> iterator = this.vertexes.iterator();
        OpenVector4f fp = iterator.next();
        float minX = fp.x();
        float minY = fp.y();
        float minZ = fp.z();
        float maxX = fp.x();
        float maxY = fp.y();
        float maxZ = fp.z();
        while (iterator.hasNext()) {
            OpenVector4f point = iterator.next();
            minX = Math.min(minX, point.x());
            minY = Math.min(minY, point.y());
            minZ = Math.min(minZ, point.z());
            maxX = Math.max(maxX, point.x());
            maxY = Math.max(maxY, point.y());
            maxZ = Math.max(maxZ, point.z());
        }
        this.box = new OpenRectangle3f(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ);
        return this.box;
    }

    public void mul(IMatrix4f matrix) {
        for (OpenVector4f vector : this.getVertexes()) {
            vector.transform(matrix);
        }
        this.box = null;
        this.aabb = null;
    }

    public void add(float x, float y, float z, float width, float height, float depth) {
        List<OpenVector4f> list = this.getVertexes();
        list.add(new OpenVector4f(x, y, z, 1.0f));
        list.add(new OpenVector4f(x + width, y, z, 1.0f));
        list.add(new OpenVector4f(x + width, y + height, z, 1.0f));
        list.add(new OpenVector4f(x, y + height, z, 1.0f));
        list.add(new OpenVector4f(x, y, z + depth, 1.0f));
        list.add(new OpenVector4f(x + width, y, z + depth, 1.0f));
        list.add(new OpenVector4f(x + width, y + height, z + depth, 1.0f));
        list.add(new OpenVector4f(x, y + height, z + depth, 1.0f));
        this.box = null;
        this.aabb = null;
    }

    public void add(OpenVoxelShape shape1) {
        List<OpenVector4f> list = this.getVertexes();
        list.addAll(shape1.getVertexes());
        this.box = null;
    }

    public void add(IRectangle3f rect) {
        this.add(rect.x(), rect.y(), rect.z(), rect.width(), rect.height(), rect.depth());
    }

    public void add(IVector3f vertex) {
        this.add(new OpenVector4f(vertex.x(), vertex.y(), vertex.z(), 1.0f));
    }

    public void add(OpenVector4f vertex) {
        List<OpenVector4f> list = this.getVertexes();
        list.add(vertex);
        this.box = null;
    }

    public boolean isEmpty() {
        return this.vertexes == null && this.box == null;
    }

    public void optimize() {
        if (this.vertexes == null || this.vertexes.size() <= 8) {
            return;
        }
        List<OpenVector4f> list = this.getVertexes();
        LinkedHashSet<OpenVector4f> uniquesVertexes = new LinkedHashSet<OpenVector4f>(list.size());
        uniquesVertexes.addAll(list);
        this.vertexes = Collections.newList(uniquesVertexes);
    }

    public OpenVoxelShape copy() {
        OpenVoxelShape shape = new OpenVoxelShape();
        shape.box = this.box;
        shape.aabb = this.aabb;
        if (this.vertexes != null) {
            ArrayList<OpenVector4f> newVertexes = new ArrayList<OpenVector4f>();
            newVertexes.ensureCapacity(this.vertexes.size());
            for (OpenVector4f vector : this.vertexes) {
                newVertexes.add(vector.copy());
            }
            shape.vertexes = newVertexes;
        }
        return shape;
    }

    @Override
    public Iterator<OpenVector4f> iterator() {
        if (this.vertexes != null) {
            return this.vertexes.iterator();
        }
        return this.getVertexes(this.box).iterator();
    }

    private List<OpenVector4f> getVertexes() {
        if (this.vertexes == null) {
            this.vertexes = this.getVertexes(this.box);
        }
        return this.vertexes;
    }

    private List<OpenVector4f> getVertexes(IRectangle3f box) {
        if (box == null) {
            return Collections.newList(new OpenVector4f[0]);
        }
        return Collections.newList(new OpenVector4f(box.minX(), box.minY(), box.minZ(), 1.0f), new OpenVector4f(box.maxX(), box.minY(), box.minZ(), 1.0f), new OpenVector4f(box.maxX(), box.maxY(), box.minZ(), 1.0f), new OpenVector4f(box.minX(), box.maxY(), box.minZ(), 1.0f), new OpenVector4f(box.minX(), box.minY(), box.maxZ(), 1.0f), new OpenVector4f(box.maxX(), box.minY(), box.maxZ(), 1.0f), new OpenVector4f(box.maxX(), box.maxY(), box.maxZ(), 1.0f), new OpenVector4f(box.minX(), box.maxY(), box.maxZ(), 1.0f));
    }
}

