/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import moe.plushie.armourers_workshop.api.core.math.IVector3i;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class OpenVector3d {
    public static final OpenVector3d ZERO = new OpenVector3d(0.0, 0.0, 0.0);
    public double x;
    public double y;
    public double z;

    public OpenVector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static OpenVector3d fromRGB24(int rgb) {
        double d0 = (double)(rgb >> 16 & 0xFF) / 255.0;
        double d1 = (double)(rgb >> 8 & 0xFF) / 255.0;
        double d2 = (double)(rgb & 0xFF) / 255.0;
        return new OpenVector3d(d0, d1, d2);
    }

    public static OpenVector3d atCenterOf(IVector3i pos) {
        return new OpenVector3d((double)pos.x() + 0.5, (double)pos.y() + 0.5, (double)pos.z() + 0.5);
    }

    public static OpenVector3d atLowerCornerOf(IVector3i pos) {
        return new OpenVector3d(pos.x(), pos.y(), pos.z());
    }

    public static OpenVector3d atBottomCenterOf(IVector3i pos) {
        return new OpenVector3d((double)pos.x() + 0.5, pos.y(), (double)pos.z() + 0.5);
    }

    public static OpenVector3d upFromBottomCenterOf(IVector3i pos, double offset) {
        return new OpenVector3d((double)pos.x() + 0.5, (double)pos.y() + offset, (double)pos.z() + 0.5);
    }

    public static OpenVector3d directionFromRotation(float a, float b) {
        double f = Math.cos((double)(-b) * (Math.PI / 180) - Math.PI);
        double f1 = Math.sin((double)(-b) * (Math.PI / 180) - Math.PI);
        double f2 = -Math.cos((double)(-a) * (Math.PI / 180));
        double f3 = Math.sin((double)(-a) * (Math.PI / 180));
        return new OpenVector3d(f1 * f2, f3, f * f2);
    }

    public OpenVector3d vectorTo(OpenVector3d pos) {
        return new OpenVector3d(pos.x - this.x, pos.y - this.y, pos.z - this.z);
    }

    public OpenVector3d normalize() {
        double d0 = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return d0 < 1.0E-4 ? ZERO : new OpenVector3d(this.x / d0, this.y / d0, this.z / d0);
    }

    public double dot(OpenVector3d vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public OpenVector3d cross(OpenVector3d vec) {
        return new OpenVector3d(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x);
    }

    public OpenVector3d subtract(OpenVector3d delta) {
        return this.subtract(delta.x, delta.y, delta.z);
    }

    public OpenVector3d subtract(double tx, double ty, double tz) {
        return this.add(-tx, -ty, -tz);
    }

    public OpenVector3d add(OpenVector3d delta) {
        return this.add(delta.x, delta.y, delta.z);
    }

    public OpenVector3d add(double tx, double ty, double tz) {
        return new OpenVector3d(this.x + tx, this.y + ty, this.z + tz);
    }

    public double distanceTo(OpenVector3d pos) {
        double d0 = pos.x - this.x;
        double d1 = pos.y - this.y;
        double d2 = pos.z - this.z;
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public double distanceToSqr(OpenVector3d pos) {
        double d0 = pos.x - this.x;
        double d1 = pos.y - this.y;
        double d2 = pos.z - this.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double distanceToSqr(double tx, double ty, double tz) {
        double d0 = tx - this.x;
        double d1 = ty - this.y;
        double d2 = tz - this.z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public OpenVector3d scale(double v) {
        return this.multiply(v, v, v);
    }

    public OpenVector3d reverse() {
        return this.scale(-1.0);
    }

    public OpenVector3d multiply(OpenVector3d pos) {
        return this.multiply(pos.x, pos.y, pos.z);
    }

    public OpenVector3d multiply(double dx, double dy, double dz) {
        return new OpenVector3d(this.x * dx, this.y * dy, this.z * dz);
    }

    public double length() {
        return OpenMath.sqrt(OpenMath.fma(this.x, this.x, OpenMath.fma(this.y, this.y, this.z * this.z)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenVector3d)) {
            return false;
        }
        OpenVector3d that = (OpenVector3d)o;
        return Double.compare(this.x, that.x) == 0 && Double.compare(this.y, that.y) == 0 && Double.compare(this.z, that.z) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return OpenMath.format("(%lf %lf %lf)", this.x, this.y, this.z);
    }

    public OpenVector3d xRot(float value) {
        double f = Math.cos(value);
        double f1 = Math.sin(value);
        double d0 = this.x;
        double d1 = this.y * f + this.z * f1;
        double d2 = this.z * f - this.y * f1;
        return new OpenVector3d(d0, d1, d2);
    }

    public OpenVector3d yRot(float p_178785_1_) {
        double f = Math.cos(p_178785_1_);
        double f1 = Math.sin(p_178785_1_);
        double d0 = this.x * f + this.z * f1;
        double d1 = this.y;
        double d2 = this.z * f - this.x * f1;
        return new OpenVector3d(d0, d1, d2);
    }

    public OpenVector3d zRot(float p_242988_1_) {
        double f = Math.cos(p_242988_1_);
        double f1 = Math.sin(p_242988_1_);
        double d0 = this.x * f + this.y * f1;
        double d1 = this.y * f - this.x * f1;
        double d2 = this.z;
        return new OpenVector3d(d0, d1, d2);
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public OpenVector3d copy() {
        return new OpenVector3d(this.x, this.y, this.z);
    }
}

