/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.core.math.OpenAxisAlignedBoundingBox;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;

public class OpenTransformedBoundingBox {
    private final OpenMatrix4f transform;
    private final OpenAxisAlignedBoundingBox boundingBox;
    private OpenAxisAlignedBoundingBox transformedBoundingBox;
    private OpenVector3f size;
    private ArrayList<OpenVector3f> vertices;

    public OpenTransformedBoundingBox(OpenMatrix4f transform, OpenAxisAlignedBoundingBox boundingBox) {
        this.transform = transform;
        this.boundingBox = boundingBox;
    }

    public ArrayList<OpenVector3f> getVertices() {
        if (this.vertices == null) {
            this.vertices = this._vertexs(this.boundingBox);
            for (OpenVector3f v : this.vertices) {
                v.transform(this.transform);
            }
        }
        return this.vertices;
    }

    public boolean intersects(OpenAxisAlignedBoundingBox box) {
        return this.getTransformedBoundingBox().intersects(box);
    }

    public OpenMatrix4f getTransform() {
        return this.transform;
    }

    public OpenAxisAlignedBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public OpenAxisAlignedBoundingBox getTransformedBoundingBox() {
        if (this.transformedBoundingBox == null) {
            this.transformedBoundingBox = this.boundingBox.transforming(this.transform);
        }
        return this.transformedBoundingBox;
    }

    private ArrayList<OpenVector3f> _vertexs(OpenAxisAlignedBoundingBox box) {
        ArrayList<OpenVector3f> v = new ArrayList<OpenVector3f>();
        v.add(new OpenVector3f(box.minX(), box.minY(), box.minZ()));
        v.add(new OpenVector3f(box.maxX(), box.minY(), box.minZ()));
        v.add(new OpenVector3f(box.minX(), box.maxY(), box.minZ()));
        v.add(new OpenVector3f(box.maxX(), box.maxY(), box.minZ()));
        v.add(new OpenVector3f(box.minX(), box.minY(), box.maxZ()));
        v.add(new OpenVector3f(box.maxX(), box.minY(), box.maxZ()));
        v.add(new OpenVector3f(box.minX(), box.maxY(), box.maxZ()));
        v.add(new OpenVector3f(box.maxX(), box.maxY(), box.maxZ()));
        return v;
    }
}

