/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SkinUnlockItem
extends FlavouredItem {
    private final SkinSlotType slotType;

    public SkinUnlockItem(SkinSlotType slotType, Item.Properties properties) {
        super(properties);
        this.slotType = slotType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        SkinType skinType = this.slotType.getSkinType();
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)player);
        if (wardrobe == null || skinType == null) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        MutableComponent skinName = TranslateUtils.Name.of(skinType);
        if (wardrobe.getUnlockedSize(this.slotType) >= this.slotType.getMaxSize()) {
            player.m_213846_((Component)Component.m_237110_((String)"chat.armourers_workshop.slotUnlockedFailed", (Object[])new Object[]{skinName}));
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        int count = wardrobe.getUnlockedSize(this.slotType) + 1;
        wardrobe.setUnlockedSize(this.slotType, count);
        wardrobe.broadcast();
        player.m_213846_((Component)Component.m_237110_((String)"chat.armourers_workshop.slotUnlocked", (Object[])new Object[]{skinName, Integer.toString(count)}));
        ItemStack resultStack = itemStack.m_41777_();
        resultStack.m_41774_(1);
        player.m_21008_(hand, resultStack);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }
}

