/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SkinItem
extends BlockItem
implements IItemPropertiesProvider {
    public SkinItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        SkinSlotType slotType = SkinSlotType.byType(descriptor.getType());
        if (descriptor.isEmpty() || slotType == null) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)player);
        if (wardrobe == null || !wardrobe.isEditable(player) || !wardrobe.isSupported(slotType)) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        int slot = wardrobe.getFreeSlot(slotType);
        if (!wardrobe.getItem(slotType, slot).m_41619_()) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        ItemStack resultStack = itemStack.m_41777_();
        wardrobe.setItem(slotType, slot, resultStack.m_41620_(1));
        wardrobe.broadcast();
        player.m_21008_(hand, resultStack);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        ItemStack itemStack = context.m_43722_();
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.getType() != SkinTypes.BLOCK) {
            return InteractionResult.PASS;
        }
        return super.m_40576_((BlockPlaceContext)new SkinBlockPlaceContext((UseOnContext)context));
    }

    public Component m_7626_(ItemStack itemStack) {
        Skin skin = SkinLoader.getInstance().getSkin(itemStack);
        if (skin != null && !skin.getCustomName().trim().isEmpty()) {
            return TranslateUtils.formatted(skin.getCustomName());
        }
        if (skin != null) {
            return TranslateUtils.Name.of(skin.getType());
        }
        return super.m_7626_(itemStack);
    }

    public String m_5524_() {
        return this.m_41467_();
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("loading"), (itemStack, level, entity, id) -> {
            SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
            BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.INVENTORY);
            if (bakedSkin != null) {
                return 0.0f;
            }
            return (float)descriptor.getType().getId() / 1000.0f;
        });
    }
}

