/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.IItemGroup;
import moe.plushie.armourers_workshop.api.common.IItemGroupProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.holiday.Holiday;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModHolidays;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GiftSackItem
extends FlavouredItem
implements IItemGroupProvider,
IItemTintColorProvider {
    public GiftSackItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack of(Holiday holiday) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.GIFT_SACK.get());
        ComponentAPI.set(stack, (IDataComponentType)ModDataComponents.HOLIDAY.get(), holiday);
        if (holiday.getHandler() != null) {
            ComponentAPI.set(stack, (IDataComponentType)ModDataComponents.GIFT_COLOR_BG.get(), holiday.getHandler().getBackgroundColor());
            ComponentAPI.set(stack, (IDataComponentType)ModDataComponents.GIFT_COLOR_FG.get(), holiday.getHandler().getForegroundColor());
        }
        return stack;
    }

    public static ItemStack getGift(ItemStack itemStack, Player player) {
        Holiday holiday = (Holiday)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.HOLIDAY.get());
        if (holiday != null && holiday.getHandler() != null) {
            return holiday.getHandler().getGift(player);
        }
        return ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.GIFT.get(), ItemStack.f_41583_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        ItemStack giftStack = GiftSackItem.getGift(itemStack, player);
        if (giftStack.m_41619_()) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (!level.m_5776_()) {
            if (player.m_150109_().m_36054_(giftStack)) {
                itemStack.m_41774_(1);
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"chat.armourers_workshop.inventoryFull"));
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    @Override
    public void fillItemGroup(List<ItemStack> results, IItemGroup group) {
        for (Holiday holiday : ModHolidays.getHolidays()) {
            if (holiday.getHandler() == null) continue;
            results.add(GiftSackItem.of(holiday));
        }
    }

    @Override
    public int getTintColor(ItemStack itemStack, int index) {
        if (index == 1) {
            return ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.GIFT_COLOR_FG.get(), 0x333333) | 0xFF000000;
        }
        return ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.GIFT_COLOR_BG.get(), 0xFFFFFF) | 0xFF000000;
    }
}

