/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.DataSerializers;

public class EntityProfile
implements IDataSerializable.Immutable {
    public static final IDataCodec<EntityProfile> CODEC = IDataCodec.COMPOUND_TAG.serializer(EntityProfile::new);
    private final IResourceLocation registryName;
    private final SupportMap supports;
    private final List<IResourceLocation> transformers;
    private final boolean locked;

    public EntityProfile(IResourceLocation registryName, Map<SkinSlotType, String> supports, List<IResourceLocation> transformers, boolean locked) {
        this.registryName = registryName;
        this.supports = new SupportMap(supports);
        this.transformers = transformers;
        this.locked = locked;
    }

    public EntityProfile(IDataSerializer serializer) {
        this.registryName = serializer.read(CodingKeys.NAME);
        this.supports = serializer.read(CodingKeys.SLOTS);
        this.transformers = serializer.read(CodingKeys.TRANSFORMERS);
        this.locked = serializer.read(CodingKeys.LOCKED);
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        serializer.write(CodingKeys.NAME, this.registryName);
        serializer.write(CodingKeys.SLOTS, this.supports);
        serializer.write(CodingKeys.TRANSFORMERS, this.transformers);
        serializer.write(CodingKeys.LOCKED, this.locked);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isSupported(SkinSlotType slotType) {
        return this.supports.hasProvider(slotType);
    }

    public int getMaxCount(SkinSlotType slotType) {
        Function<SkinSlotType, Integer> provider = this.supports.getProvider(slotType);
        if (provider != null) {
            return provider.apply(slotType);
        }
        if (slotType == SkinSlotType.DEFAULT) {
            return slotType.getMaxSize();
        }
        return 0;
    }

    public Collection<SkinSlotType> getSlots() {
        return this.supports.getSlots();
    }

    public List<IResourceLocation> getTransformers() {
        return this.transformers;
    }

    public IResourceLocation getRegistryName() {
        return this.registryName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityProfile)) {
            return false;
        }
        EntityProfile that = (EntityProfile)o;
        return Objects.equals(this.registryName, that.registryName) && this.locked == that.locked && Objects.equals(this.supports, that.supports) && Objects.equals(this.transformers, that.transformers);
    }

    public int hashCode() {
        return this.registryName.hashCode();
    }

    public String toString() {
        return Objects.toString(this, "name", this.registryName, "locked", this.locked, "transformers", this.transformers);
    }

    public static boolean same(EntityProfile lhs, EntityProfile rhs) {
        return lhs.locked == rhs.locked && Objects.equals(lhs.supports, rhs.supports) && Objects.equals(lhs.transformers, rhs.transformers);
    }

    private static class SupportMap
    implements IDataSerializable.Immutable {
        public static final IDataCodec<SupportMap> CODEC = IDataCodec.COMPOUND_TAG.serializer(SupportMap::new);
        private final Map<SkinSlotType, String> supports;
        private Map<SkinSlotType, Function<SkinSlotType, Integer>> providers;

        public SupportMap(Map<SkinSlotType, String> supports) {
            this.supports = supports;
        }

        public SupportMap(IDataSerializer serializer) {
            this.supports = Collections.immutableMap(builder -> {
                for (Map.Entry<SkinSlotType, IDataSerializerKey<String>> entry : CodingKeys.ALL_SLOTS.entrySet()) {
                    String value = serializer.read(entry.getValue());
                    if (value == null) continue;
                    builder.put((Object)entry.getKey(), (Object)value);
                }
            });
        }

        @Override
        public void serialize(IDataSerializer serializer) {
            for (Map.Entry<SkinSlotType, IDataSerializerKey<String>> entry : CodingKeys.ALL_SLOTS.entrySet()) {
                String value = this.supports.get((Object)entry.getKey());
                if (value == null) continue;
                serializer.write(entry.getValue(), value);
            }
        }

        public Collection<SkinSlotType> getSlots() {
            return this.supports.keySet();
        }

        public boolean hasProvider(SkinSlotType slotType) {
            return this.supports.containsKey((Object)slotType);
        }

        public Function<SkinSlotType, Integer> getProvider(SkinSlotType slotType) {
            if (this.providers != null) {
                return this.providers.get((Object)slotType);
            }
            this.providers = Collections.immutableMap(builder -> this.supports.forEach((slotType1, name) -> {
                Function<SkinSlotType, Integer> provider = this.getProviderByName((String)name);
                builder.put((Object)slotType1, provider);
            }));
            return this.providers.get((Object)slotType);
        }

        private Function<SkinSlotType, Integer> getProviderByName(String name) {
            if (name.equals("default_mob_slots")) {
                return it -> ModConfig.Common.prefersWardrobeMobSlots;
            }
            if (name.equals("default_player_slots")) {
                return it -> ModConfig.Common.prefersWardrobePlayerSlots;
            }
            try {
                int count = Integer.parseInt(name);
                return it -> count;
            }
            catch (Exception e) {
                e.printStackTrace();
                return it -> 0;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SupportMap)) {
                return false;
            }
            SupportMap that = (SupportMap)o;
            return this.supports.equals(that.supports);
        }

        public int hashCode() {
            return this.supports.hashCode();
        }
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<IResourceLocation> NAME = IDataSerializerKey.create("Name", DataSerializers.RESOURCE_LOCATION, null);
        public static final IDataSerializerKey<Boolean> LOCKED = IDataSerializerKey.create("Locked", IDataCodec.BOOL, false);
        public static final IDataSerializerKey<List<IResourceLocation>> TRANSFORMERS = IDataSerializerKey.create("Transformers", DataSerializers.RESOURCE_LOCATION.listOf(), Collections.emptyList());
        public static final IDataSerializerKey<SupportMap> SLOTS = IDataSerializerKey.create("Slots", SupportMap.CODEC, new SupportMap(new HashMap<SkinSlotType, String>()));
        public static final Map<SkinSlotType, IDataSerializerKey<String>> ALL_SLOTS = Collections.immutableMap(builder -> {
            for (SkinSlotType slotType : SkinSlotType.values()) {
                String name = slotType.getName();
                IDataSerializerKey<Object> key = IDataSerializerKey.create(name, IDataCodec.STRING, null);
                builder.put((Object)slotType, key);
            }
        });

        private CodingKeys() {
        }
    }
}

