/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.source;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.data.source.SQLTableBuilder;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinSerializer;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenUUID;
import moe.plushie.armourers_workshop.core.utils.StreamUtils;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import org.jetbrains.annotations.Nullable;

public abstract class FileDataSource {
    protected String name = "";
    protected String lastGenUUID = "";

    public abstract void connect() throws Exception;

    public abstract void disconnect() throws Exception;

    public void setReconnectHandler(Runnable reconnectHandler) {
    }

    public String save(@Nullable String id, InputStream stream) throws Exception {
        byte[] bytes = StreamUtils.readStreamToByteArray(stream);
        int fileHash = Arrays.hashCode(bytes);
        String identifier = this.searchNode(fileHash, bytes);
        if (identifier != null) {
            return identifier;
        }
        Skin skin = SkinSerializer.readFromStream(null, new ByteArrayInputStream(bytes));
        identifier = this.getFreeId(id);
        this.insertNode(identifier, skin, fileHash, bytes);
        return identifier;
    }

    public InputStream load(String id) throws Exception {
        byte[] bytes = this.queryNode(id);
        return new ByteArrayInputStream(bytes);
    }

    public abstract void remove(String var1) throws Exception;

    public abstract boolean contains(String var1) throws Exception;

    public abstract long getCreationTime(String var1) throws Exception;

    public abstract long getLastModifiedTime(String var1) throws Exception;

    protected abstract void insertNode(String var1, Skin var2, int var3, byte[] var4) throws Exception;

    protected abstract byte[] queryNode(String var1) throws Exception;

    protected abstract String searchNode(int var1, byte[] var2) throws Exception;

    protected abstract List<String> queryNodes() throws Exception;

    private String getFreeId(@Nullable String id) throws Exception {
        if (id != null) {
            return id;
        }
        String uuid = this.lastGenUUID;
        while (uuid.isEmpty() || this.contains(uuid)) {
            uuid = OpenUUID.randomUUIDString();
        }
        this.lastGenUUID = uuid;
        return uuid;
    }

    public static class Fallback
    extends FileDataSource {
        private final FileDataSource source;
        private final FileDataSource fallbackSource;
        private final boolean isMoveFiles;

        public Fallback(FileDataSource source, FileDataSource fallbackSource, boolean isMoveFiles) {
            this.source = source;
            this.fallbackSource = fallbackSource;
            this.isMoveFiles = isMoveFiles;
        }

        @Override
        public void setReconnectHandler(Runnable reconnectHandler) {
            super.setReconnectHandler(reconnectHandler);
            this.fallbackSource.setReconnectHandler(reconnectHandler);
        }

        @Override
        public void connect() throws Exception {
            this.fallbackSource.connect();
            this.source.connect();
            if (this.isMoveFiles) {
                this.migrateAllSkins();
            }
        }

        @Override
        public void disconnect() throws Exception {
            this.source.disconnect();
            this.fallbackSource.disconnect();
        }

        @Override
        protected void insertNode(String id, Skin skin, int hash, byte[] bytes) throws Exception {
            this.source.insertNode(id, skin, hash, bytes);
        }

        @Override
        protected byte[] queryNode(String id) throws Exception {
            try {
                return this.source.queryNode(id);
            }
            catch (FileNotFoundException exception) {
                if (this.fallbackSource.contains(id)) {
                    return this.fallbackSource.queryNode(id);
                }
                throw exception;
            }
        }

        @Override
        protected List<String> queryNodes() throws Exception {
            return this.source.queryNodes();
        }

        @Override
        protected String searchNode(int hash, byte[] bytes) throws Exception {
            return this.source.searchNode(hash, bytes);
        }

        @Override
        public void remove(String id) throws Exception {
            this.source.remove(id);
        }

        @Override
        public boolean contains(String id) throws Exception {
            return this.source.contains(id);
        }

        @Override
        public long getCreationTime(String id) throws Exception {
            return this.source.getCreationTime(id);
        }

        @Override
        public long getLastModifiedTime(String id) throws Exception {
            return this.source.getLastModifiedTime(id);
        }

        private void migrateAllSkins() throws Exception {
            for (String id : this.fallbackSource.queryNodes()) {
                try {
                    ModLog.debug("Migrate skin '{}' from '{}' into '{}'", id, this.fallbackSource.name, this.source.name);
                    byte[] bytes = this.fallbackSource.queryNode(id);
                    Skin skin = SkinSerializer.readFromStream(null, new ByteArrayInputStream(bytes));
                    int fileHash = Arrays.hashCode(bytes);
                    if (this.contains(id)) {
                        this.source.remove(id);
                    }
                    this.source.insertNode(id, skin, fileHash, bytes);
                    this.fallbackSource.remove(id);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class Local
    extends FileDataSource {
        private static final int NODE_DATA_VERSION = 2;
        private final File nodeRootPath;
        private final ExecutorService thread = moe.plushie.armourers_workshop.core.utils.Executors.newFixedThreadPool(1, "AW-SKIN-IO");
        private final Map<String, Node> nodes = new ConcurrentHashMap<String, Node>();

        public Local(File rootPath) {
            this.name = rootPath.getParentFile().getName();
            this.nodeRootPath = new File(rootPath, "objects");
        }

        @Override
        public void connect() throws Exception {
            ModLog.debug("Connect to file db: '{}'", this.name);
            this.loadNodes();
        }

        @Override
        public void disconnect() throws Exception {
            ModLog.debug("Disconnect from file db: '{}'", this.name);
            this.thread.shutdown();
        }

        @Override
        protected void insertNode(String id, Skin skin, int hash, byte[] bytes) {
            ModLog.debug("Save file '{}' into '{}'", id, this.name);
            Node newNode = new Node(id, hash, bytes);
            newNode.save(new ByteArrayInputStream(bytes));
            this.nodes.put(newNode.id, newNode);
        }

        @Override
        protected byte[] queryNode(String id) throws Exception {
            File parent;
            Node node = this.nodes.get(id);
            if (node == null && (parent = new File(this.nodeRootPath, id)).isDirectory()) {
                node = this.loadNode(parent);
            }
            if (node != null && node.isValid()) {
                ModLog.debug("Load file '{}' from '{}'", id, this.name);
                return StreamUtils.readFileToByteArray(node.getFile());
            }
            throw new FileNotFoundException("the node '" + id + "' not found in " + this.name + "!");
        }

        @Override
        protected List<String> queryNodes() throws Exception {
            return new ArrayList<String>(this.nodes.keySet());
        }

        @Override
        protected String searchNode(int hash, byte[] bytes) throws Exception {
            for (Node node : this.nodes.values()) {
                if (!node.isValid() || node.fileHash != hash || !node.equalContents(bytes)) continue;
                return node.id;
            }
            return null;
        }

        @Override
        public void remove(String id) throws Exception {
            ModLog.debug("Remove file '{}' from '{}'", id, this.name);
            Node node = this.nodes.remove(id);
            if (node != null) {
                node.remove();
            }
        }

        @Override
        public boolean contains(String id) throws Exception {
            return this.nodes.containsKey(id);
        }

        @Override
        public long getCreationTime(String id) throws Exception {
            Node node = this.nodes.get(id);
            if (node != null) {
                return FileUtils.getCreationTime(node.getFile());
            }
            throw new FileNotFoundException("the node '" + id + "' not found in " + this.name + "!");
        }

        @Override
        public long getLastModifiedTime(String id) throws Exception {
            Node node = this.nodes.get(id);
            if (node != null) {
                return FileUtils.getLastModifiedTime(node.getFile());
            }
            throw new FileNotFoundException("the node '" + id + "' not found in " + this.name + "!");
        }

        private void loadNodes() {
            for (File file : FileUtils.listFilesRecursive(this.nodeRootPath)) {
                if (!file.isDirectory()) continue;
                this.loadNode(file);
            }
        }

        private Node loadNode(File parent) {
            try {
                File indexFile = new File(parent, "0");
                if (indexFile.exists()) {
                    TagSerializer serializer = new TagSerializer(new FileInputStream(indexFile));
                    Node node = new Node(serializer);
                    this.nodes.put(node.id, node);
                    return node;
                }
                String name = FileUtils.getRelativePath(parent, this.nodeRootPath);
                Node node = this.generateNode(name.substring(1), new File(parent, "1"));
                if (node != null) {
                    this.nodes.put(node.id, node);
                    return node;
                }
            }
            catch (Exception e) {
                ModLog.error("can't load file: {}, pls try fix or remove it.", parent);
            }
            return null;
        }

        private Node generateNode(String identifier, File skinFile) throws Exception {
            if (!skinFile.isFile()) {
                return null;
            }
            byte[] bytes = StreamUtils.readFileToByteArray(skinFile);
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            Skin skin = SkinSerializer.readFromStream(null, stream);
            if (skin == null) {
                return null;
            }
            Node node = new Node(identifier, Arrays.hashCode(bytes), bytes);
            node.save(new ByteArrayInputStream(bytes));
            return node;
        }

        private class Node
        implements IDataSerializable.Immutable {
            final String id;
            final int version;
            final int fileSize;
            final int fileHash;

            Node(String id, int hash, byte[] bytes) {
                this.id = id;
                this.version = 2;
                this.fileSize = bytes.length;
                this.fileHash = hash;
            }

            Node(IDataSerializer serializer) {
                this.id = serializer.read(CodingKeys.UID);
                this.version = serializer.read(CodingKeys.VERSION);
                this.fileSize = serializer.read(CodingKeys.FILE_SIZE);
                this.fileHash = serializer.read(CodingKeys.FILE_HASH);
            }

            @Override
            public void serialize(IDataSerializer serializer) {
                serializer.write(CodingKeys.UID, this.id);
                serializer.write(CodingKeys.VERSION, this.version);
                serializer.write(CodingKeys.FILE_SIZE, this.fileSize);
                serializer.write(CodingKeys.FILE_HASH, this.fileHash);
            }

            public void save(InputStream inputStream) {
                Local.this.thread.execute(() -> {
                    try {
                        File skinFile = this.getFile();
                        File indexFile = this.getIndexFile();
                        FileUtils.forceMkdirParent(skinFile);
                        FileOutputStream outputStream = new FileOutputStream(skinFile);
                        StreamUtils.transferTo(inputStream, outputStream);
                        TagSerializer.writeToStream(this, (OutputStream)new FileOutputStream(indexFile));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }

            public void remove() {
                Local.this.thread.execute(() -> {
                    File skinFile = this.getFile();
                    FileUtils.deleteQuietly(skinFile.getParentFile());
                });
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Node)) {
                    return false;
                }
                Node that = (Node)o;
                return this.fileSize == that.fileSize && this.fileHash == that.fileHash;
            }

            /*
             * Enabled aggressive exception aggregation
             */
            public boolean equalContents(byte[] bytes) {
                int index;
                try (FileInputStream stream = new FileInputStream(this.getFile());){
                    int readSize;
                    byte[] buff = new byte[1024];
                    for (index = 0; index < bytes.length; index += readSize) {
                        readSize = stream.read(buff);
                        if (readSize <= 0) {
                            break;
                        }
                        if (index + readSize > bytes.length) {
                            boolean bl = false;
                            return bl;
                        }
                        for (int i = 0; i < readSize; ++i) {
                            if (bytes[index + i] == buff[i]) continue;
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return index == bytes.length;
            }

            public int hashCode() {
                return Objects.hash(this.fileSize, this.fileHash);
            }

            public File getFile() {
                return new File(Local.this.nodeRootPath, this.id + "/1");
            }

            public File getIndexFile() {
                return new File(Local.this.nodeRootPath, this.id + "/0");
            }

            public boolean isValid() {
                return this.getFile().exists();
            }
        }

        private static class CodingKeys {
            public static final IDataSerializerKey<String> UID = IDataSerializerKey.create("UUID", IDataCodec.STRING, "");
            public static final IDataSerializerKey<Integer> VERSION = IDataSerializerKey.create("Version", IDataCodec.INT, 0);
            public static final IDataSerializerKey<Integer> FILE_SIZE = IDataSerializerKey.create("FileSize", IDataCodec.INT, 0);
            public static final IDataSerializerKey<Integer> FILE_HASH = IDataSerializerKey.create("FileHash", IDataCodec.INT, 0);

            private CodingKeys() {
            }
        }
    }

    public static class SQL
    extends FileDataSource {
        private final Connection connection;
        private Runnable reconnectHandler;
        private ScheduledExecutorService keepAliveChecker;
        private PreparedStatement insertStatement;
        private PreparedStatement existsStatement;
        private PreparedStatement searchStatement;
        private PreparedStatement timeStatement;
        private PreparedStatement queryStatement;
        private PreparedStatement queryAllStatement;
        private PreparedStatement removeStatement;

        public SQL(String name, Connection connection) {
            this.name = name;
            this.connection = connection;
        }

        @Override
        public void setReconnectHandler(Runnable reconnectHandler) {
            this.reconnectHandler = reconnectHandler;
        }

        @Override
        public void connect() throws SQLException {
            ModLog.debug("Connect to file db: '{}'", this.name);
            SQLTableBuilder builder = new SQLTableBuilder("Skin");
            builder.add("id", "VARCHAR(48) NOT NULL PRIMARY KEY");
            builder.add("type", "VARCHAR(48)");
            builder.add("created_at", "TIMESTAMP");
            builder.add("modified_at", "TIMESTAMP");
            builder.add("name", "VARCHAR(512)");
            builder.add("flavour", "VARCHAR(1024)");
            builder.add("author", "VARCHAR(48)");
            builder.add("hash", "INT NOT NULL");
            builder.add("file", "LONGBLOB NOT NULL");
            builder.execute(this.connection);
            this.queryAllStatement = this.connection.prepareStatement("SELECT `id` FROM `Skin`");
            this.queryStatement = this.connection.prepareStatement("SELECT `file` FROM `Skin` where `id` = (?)");
            this.searchStatement = this.connection.prepareStatement("SELECT `id`, `file` FROM `Skin` where `hash` = (?)");
            this.existsStatement = this.connection.prepareStatement("SELECT `id` FROM `Skin` where `id` = (?)");
            this.timeStatement = this.connection.prepareStatement("SELECT `created_at`, `modified_at` FROM `Skin` where `id` = (?)");
            this.insertStatement = this.connection.prepareStatement("INSERT INTO `Skin` (`id`, `type`, `author`, `name`, `flavour`, `created_at`, `modified_at`, `hash`, `file`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.removeStatement = this.connection.prepareStatement("DELETE FROM `Skin` where `id` = (?)");
            if (ModConfig.Common.skinDatabaseKeepAlive > 0) {
                this.keepAliveChecker = this.createKeepAliveChecker(ModConfig.Common.skinDatabaseKeepAlive);
            }
        }

        @Override
        public void disconnect() throws SQLException {
            ModLog.debug("Disconnect from file db: '{}'", this.name);
            if (this.keepAliveChecker != null) {
                this.keepAliveChecker.shutdownNow();
                this.keepAliveChecker = null;
            }
            this.safeClose(this.removeStatement);
            this.safeClose(this.insertStatement);
            this.safeClose(this.timeStatement);
            this.safeClose(this.existsStatement);
            this.safeClose(this.searchStatement);
            this.safeClose(this.queryStatement);
            this.safeClose(this.queryAllStatement);
            this.connection.close();
        }

        @Override
        protected void insertNode(String id, Skin skin, int hash, byte[] bytes) throws SQLException {
            ModLog.debug("Save file '{}' into '{}'", id, this.name);
            this.insertStatement.setString(1, id);
            this.insertStatement.setString(2, skin.getType().getRegistryName().toString());
            this.insertStatement.setString(3, skin.getAuthorUUID());
            this.insertStatement.setString(4, skin.getCustomName());
            this.insertStatement.setString(5, skin.getFlavourText());
            this.insertStatement.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
            this.insertStatement.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
            this.insertStatement.setInt(8, hash);
            this.insertStatement.setBytes(9, bytes);
            this.insertStatement.executeUpdate();
        }

        @Override
        protected byte[] queryNode(String id) throws Exception {
            this.queryStatement.setString(1, id);
            try (ResultSet result = this.queryStatement.executeQuery();){
                if (result.next()) {
                    ModLog.debug("Load file '{}' from '{}'", id, this.name);
                    byte[] byArray = result.getBytes(1);
                    return byArray;
                }
            }
            throw new FileNotFoundException("the file '" + id + "' not found in " + this.name + "!");
        }

        @Override
        protected List<String> queryNodes() throws Exception {
            try (ResultSet result = this.queryAllStatement.executeQuery();){
                ArrayList<String> results = new ArrayList<String>();
                while (result.next()) {
                    results.add(result.getString(1));
                }
                ArrayList<String> arrayList = results;
                return arrayList;
            }
        }

        @Override
        protected String searchNode(int hash, byte[] bytes) throws SQLException {
            this.searchStatement.setInt(1, hash);
            try (ResultSet result = this.searchStatement.executeQuery();){
                while (result.next()) {
                    byte[] bytes2 = result.getBytes(2);
                    if (!Arrays.equals(bytes, bytes2)) continue;
                    String string = result.getString(1);
                    return string;
                }
                String string = null;
                return string;
            }
        }

        @Override
        public void remove(String id) throws Exception {
            ModLog.debug("Remove file '{}' from '{}'", id, this.name);
            this.removeStatement.setString(1, id);
            this.removeStatement.executeUpdate();
        }

        @Override
        public boolean contains(String id) throws SQLException {
            this.existsStatement.setString(1, id);
            try (ResultSet result = this.existsStatement.executeQuery();){
                boolean bl = result.next();
                return bl;
            }
        }

        @Override
        public long getCreationTime(String id) throws SQLException {
            this.timeStatement.setString(1, id);
            try (ResultSet result = this.timeStatement.executeQuery();){
                if (result.next()) {
                    long l = result.getTimestamp(1).getTime();
                    return l;
                }
                long l = 0L;
                return l;
            }
        }

        @Override
        public long getLastModifiedTime(String id) throws SQLException {
            this.timeStatement.setString(1, id);
            try (ResultSet result = this.timeStatement.executeQuery();){
                if (result.next()) {
                    long l = result.getTimestamp(2).getTime();
                    return l;
                }
                long l = 0L;
                return l;
            }
        }

        private ScheduledExecutorService createKeepAliveChecker(int seconds) {
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
            executor.scheduleAtFixedRate(() -> {
                block3: {
                    try {
                        if (!this.connection.isValid(2) && this.reconnectHandler != null) {
                            this.reconnectHandler.run();
                        }
                    }
                    catch (SQLException e) {
                        if (this.reconnectHandler == null) break block3;
                        this.reconnectHandler.run();
                    }
                }
            }, 0L, seconds, TimeUnit.SECONDS);
            return executor;
        }

        private void safeClose(AutoCloseable closeable) {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

