/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.color;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;

public class TexturedPaintColor
extends SkinPaintColor {
    private static final Cache<Integer, TexturedPaintColor> POOL = CacheBuilder.newBuilder().maximumSize(2048L).build();

    protected TexturedPaintColor(int value, int rgb, SkinPaintType paintType) {
        super(value, rgb, paintType);
    }

    public static SkinPaintColor of(int value) {
        if (value == 0) {
            return CLEAR;
        }
        return TexturedPaintColor.of(value, TexturedPaintColor.getPaintType(value));
    }

    public static SkinPaintColor of(int rgb, SkinPaintType paintType) {
        int value = rgb & 0xFFFFFF | (paintType.getId() & 0xFF) << 24;
        TexturedPaintColor paintColor = (TexturedPaintColor)POOL.getIfPresent((Object)value);
        if (paintColor == null) {
            paintColor = new TexturedPaintColor(value, rgb, paintType);
            POOL.put((Object)value, (Object)paintColor);
        }
        return paintColor;
    }
}

