/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.color;

import java.util.HashMap;
import java.util.Set;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;

public class ColorDescriptor {
    private final HashMap<SkinPaintType, Channel> channels = new HashMap();

    public void add(SkinPaintColor color) {
        SkinPaintType paintType = color.getPaintType();
        if (this.shouldRecordChannel(paintType)) {
            Channel ch = this.channels.computeIfAbsent(paintType, k -> new Channel());
            ch.red += color.getRed();
            ch.green += color.getGreen();
            ch.blue += color.getBlue();
            ++ch.total;
            ch.setChanged();
        }
    }

    public void add(ColorDescriptor descriptor) {
        descriptor.channels.forEach((paintType, otherChannel) -> {
            Channel ch = this.channels.computeIfAbsent((SkinPaintType)paintType, k -> new Channel());
            ch.red += otherChannel.red;
            ch.green += otherChannel.green;
            ch.blue += otherChannel.blue;
            ch.total += otherChannel.total;
            ch.setChanged();
        });
    }

    public boolean isEmpty() {
        return this.channels.isEmpty();
    }

    public SkinPaintColor getAverageColor(SkinPaintType paintType) {
        Channel channel = this.channels.get(paintType);
        if (channel != null) {
            return channel.getResolvedColor();
        }
        return null;
    }

    public Set<SkinPaintType> getPaintTypes() {
        return this.channels.keySet();
    }

    public ColorDescriptor copy() {
        ColorDescriptor result = new ColorDescriptor();
        result.add(this);
        return result;
    }

    private boolean shouldRecordChannel(SkinPaintType paintType) {
        if (paintType == SkinPaintTypes.RAINBOW) {
            return true;
        }
        if (paintType == SkinPaintTypes.TEXTURE) {
            return true;
        }
        return paintType.getDyeType() != null;
    }

    private static class Channel {
        int total = 0;
        int red = 0;
        int green = 0;
        int blue = 0;
        SkinPaintColor resolvedColor;

        private Channel() {
        }

        void setChanged() {
            this.resolvedColor = null;
        }

        SkinPaintColor getResolvedColor() {
            if (this.resolvedColor != null) {
                return this.resolvedColor;
            }
            if (this.total == 0) {
                this.resolvedColor = SkinPaintColor.CLEAR;
                return this.resolvedColor;
            }
            int r = this.red / this.total;
            int g = this.green / this.total;
            int b = this.blue / this.total;
            this.resolvedColor = SkinPaintColor.of(r, g, b, SkinPaintTypes.NORMAL);
            return this.resolvedColor;
        }
    }
}

