/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.Optional;
import moe.plushie.armourers_workshop.api.common.IEntityCapability;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobeJS;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.data.EntityActionSet;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EntityVariableStorageImpl;
import moe.plushie.armourers_workshop.core.utils.LazyOptional;
import moe.plushie.armourers_workshop.init.ModCapabilities;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityDataStorage {
    public static EntityImpl of(Entity entity) {
        return DataContainer.of(entity, EntityImpl::new);
    }

    public static BlockEntityImpl of(BlockEntity entity) {
        return DataContainer.of(entity, BlockEntityImpl::new);
    }

    public static class EntityImpl {
        protected final LazyOptional<SkinWardrobe> wardrobe = LazyOptional.of(() -> ((IEntityCapability)ModCapabilities.ENTITY_WARDROBE.get()).get(entity));
        protected final LazyOptional<SkinWardrobeJS> wardrobeJS = LazyOptional.of(() -> this.wardrobe.resolve().map(SkinWardrobeJS::new));
        protected final LazyOptional<EntityRenderData> renderData = LazyOptional.of(() -> EnvironmentExecutor.callOn(EnvironmentType.CLIENT, () -> () -> new EntityRenderData(entity)));
        protected final LazyOptional<EntityActionSet> actionSet = LazyOptional.ofNullable(EntityActionSet::new);
        protected final LazyOptional<EntityVariableStorageImpl> variableStorage = LazyOptional.ofNullable(EntityVariableStorageImpl::new);

        public EntityImpl(Entity entity) {
        }

        public Optional<SkinWardrobe> getWardrobe() {
            return this.wardrobe.resolve();
        }

        public Optional<SkinWardrobeJS> getWardrobeJS() {
            return this.wardrobeJS.resolve();
        }

        @OnlyIn(value=Dist.CLIENT)
        public Optional<EntityRenderData> getRenderData() {
            return this.renderData.resolve();
        }

        public Optional<EntityActionSet> getActionSet() {
            return this.actionSet.resolve();
        }

        public Optional<EntityVariableStorageImpl> getVariableStorage() {
            return this.variableStorage.resolve();
        }
    }

    public static class BlockEntityImpl {
        protected final LazyOptional<BlockEntityRenderData> renderData = LazyOptional.of(() -> EnvironmentExecutor.callOn(EnvironmentType.CLIENT, () -> () -> new BlockEntityRenderData(entity)));
        protected final LazyOptional<EntityVariableStorageImpl> variableStorage = LazyOptional.ofNullable(EntityVariableStorageImpl::new);

        public BlockEntityImpl(BlockEntity entity) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public Optional<BlockEntityRenderData> getRenderData() {
            return this.renderData.resolve();
        }

        public Optional<EntityVariableStorageImpl> getVariableStorage() {
            return this.variableStorage.resolve();
        }
    }
}

