/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class EntityCollisionShape {
    public static final IDataCodec<EntityCollisionShape> CODEC = IDataCodec.FLOAT.listOf().xmap(EntityCollisionShape::new, EntityCollisionShape::toList);
    private final OpenRectangle3f rect;

    public EntityCollisionShape(OpenRectangle3f rect) {
        this.rect = rect;
    }

    public EntityCollisionShape(List<Float> values) {
        this.rect = new OpenRectangle3f(values);
    }

    public static EntityCollisionShape size(OpenRectangle3f rect) {
        return new EntityCollisionShape(rect);
    }

    public OpenRectangle3f getRect() {
        return this.rect;
    }

    public List<Float> toList() {
        return this.rect.toList();
    }

    public String toString() {
        return Objects.toString(this, "rect", this.rect);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityCollisionShape)) {
            return false;
        }
        EntityCollisionShape that = (EntityCollisionShape)o;
        return Objects.equals(this.rect, that.rect);
    }

    public int hashCode() {
        return Objects.hash(this.rect);
    }
}

