/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import moe.plushie.armourers_workshop.core.data.source.FileDataSource;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinSerializer;
import moe.plushie.armourers_workshop.init.ModConfig;
import org.jetbrains.annotations.Nullable;

public class DataManager {
    private static final DataManager INSTANCE = new DataManager();
    private FileDataSource fileDataSource;
    private final HashMap<String, Connection> reusableConnections = new HashMap();

    public static DataManager getInstance() {
        return INSTANCE;
    }

    public void connect(File rootPath) {
        try {
            this.reusableConnections.clear();
            this.fileDataSource = this.createFileDataSource(new FileDataSource.Local(rootPath));
            if (this.fileDataSource != null) {
                this.fileDataSource.connect();
                this.fileDataSource.setReconnectHandler(() -> {
                    this.disconnect();
                    this.connect(rootPath);
                });
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void disconnect() {
        try {
            this.reusableConnections.clear();
            if (this.fileDataSource != null) {
                this.fileDataSource.disconnect();
                this.fileDataSource = null;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String saveSkin(@Nullable String id, Skin skin) throws Exception {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(5120);){
            SkinSerializer.writeToStream(skin, null, outputStream);
            String string = this.saveSkinData(id, new ByteArrayInputStream(outputStream.toByteArray()));
            return string;
        }
    }

    public Skin loadSkin(String id) throws Exception {
        try (InputStream inputStream = this.loadSkinData(id);){
            Skin skin = SkinSerializer.readFromStream(null, inputStream);
            return skin;
        }
    }

    public void removeSkin(String id) throws Exception {
        if (this.fileDataSource != null) {
            this.fileDataSource.remove(id);
            return;
        }
        throw new Exception("Missing data source connect!");
    }

    public String saveSkinData(@Nullable String id, InputStream inputStream) throws Exception {
        if (this.fileDataSource != null) {
            return this.fileDataSource.save(id, inputStream);
        }
        throw new Exception("Missing data source connect!");
    }

    public InputStream loadSkinData(String id) throws Exception {
        if (this.fileDataSource != null) {
            return this.fileDataSource.load(id);
        }
        throw new Exception("Missing data source connect!");
    }

    public boolean isConnected() {
        return this.fileDataSource != null;
    }

    private FileDataSource createFileDataSource(FileDataSource fallback) throws Exception {
        String uri = ModConfig.Common.skinDatabaseURL;
        if (uri.startsWith("jdbc:")) {
            String name = uri.replaceAll("jdbc:([^:]+):(.+)", "$1");
            FileDataSource.SQL source = new FileDataSource.SQL(name, this.createConnection(uri));
            return switch (ModConfig.Common.skinDatabaseFallback) {
                case 0 -> new FileDataSource.Fallback(source, fallback, false);
                case 2 -> new FileDataSource.Fallback(source, fallback, true);
                default -> source;
            };
        }
        return fallback;
    }

    private Connection createConnection(String uri) throws Exception {
        Connection connection = this.reusableConnections.get(uri);
        if (connection != null) {
            return connection;
        }
        connection = DriverManager.getConnection(uri);
        this.reusableConnections.put(uri, connection);
        return connection;
    }
}

