/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerKey;

public class DataContainerKey<T>
implements IAssociatedContainerKey<T> {
    private static final AtomicInteger GENERATOR = new AtomicInteger();
    private final int id = GENERATOR.getAndIncrement();
    private final String name;
    private final Class<T> type;
    private final Supplier<T> defaultValue;

    public DataContainerKey(String name, Class<T> type, Supplier<T> defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public static <T> DataContainerKey<T> of(String name, Class<T> type) {
        return new DataContainerKey<T>(name, type, null);
    }

    public static <T> DataContainerKey<T> of(String name, Class<T> type, Supplier<T> provider) {
        return new DataContainerKey<T>(name, type, provider);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataContainerKey)) {
            return false;
        }
        DataContainerKey that = (DataContainerKey)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T getDefaultValue() {
        if (this.defaultValue != null) {
            return this.defaultValue.get();
        }
        return null;
    }
}

