/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.texture;

import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.texture.SmartTexture;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureAnimation;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureAnimationController {
    private static final OpenMatrix4f IDENTITY = OpenMatrix4f.identity();
    public static final TextureAnimationController NONE = new TextureAnimationController(0, 0, SkinTextureAnimation.Mode.LOOP);
    public static final TextureAnimationController DEFAULT = new TextureAnimationController(25, 256, SkinTextureAnimation.Mode.LOOP);
    private final int frameCount;
    private final float frameTime;
    private final OpenMatrix4f[] frames;

    public TextureAnimationController(SkinTextureAnimation animation) {
        this(animation.getFrameTime(), animation.getFrameCount(), animation.getFrmaeMode());
    }

    public TextureAnimationController(int frameTime, int frameCount, SkinTextureAnimation.Mode frameMode) {
        this.frames = this._genTextureMatrices(frameCount, frameMode);
        this.frameTime = (float)Math.max(frameTime, 1) / 1000.0f;
        this.frameCount = this.frames.length;
    }

    public static TextureAnimationController of(RenderType renderType) {
        if (renderType == SkinRenderType.BLOCK_FACE_SOLID || renderType == SkinRenderType.BLOCK_FACE_LIGHTING || renderType == SkinRenderType.BLOCK_FACE_TRANSLUCENT || renderType == SkinRenderType.BLOCK_FACE_LIGHTING_TRANSLUCENT) {
            return DEFAULT;
        }
        SmartTexture storage = SmartTexture.of(renderType);
        if (storage != null) {
            return storage.getAnimationController();
        }
        return NONE;
    }

    public OpenMatrix4f getTextureMatrix(double animationTime) {
        if (this.frameCount != 0) {
            int idx = (int)(animationTime / (double)this.frameTime);
            return this.frames[idx % this.frameCount];
        }
        return IDENTITY;
    }

    private OpenMatrix4f[] _genTextureMatrices(int total, SkinTextureAnimation.Mode mode) {
        if (total <= 0) {
            return new OpenMatrix4f[0];
        }
        if (mode.equals(SkinTextureAnimation.Mode.LOOP)) {
            OpenMatrix4f[] frames = new OpenMatrix4f[total];
            for (int i = 0; i < total; ++i) {
                frames[i] = this._genTextureMatrix((float)i / (float)total);
            }
            return frames;
        }
        if (mode.equals(SkinTextureAnimation.Mode.BACKWARDS)) {
            OpenMatrix4f[] frames = new OpenMatrix4f[total];
            for (int i = 0; i < total; ++i) {
                frames[total - i - 1] = this._genTextureMatrix((float)i / (float)total);
            }
            return frames;
        }
        if (mode.equals(SkinTextureAnimation.Mode.BACK_AND_FORTH)) {
            int i;
            OpenMatrix4f[] frames = new OpenMatrix4f[total + total - 2];
            for (i = 0; i < total; ++i) {
                frames[i] = this._genTextureMatrix((float)i / (float)total);
            }
            for (i = 1; i < total; ++i) {
                frames[total - i - 1] = this._genTextureMatrix((float)i / (float)total);
            }
            return frames;
        }
        if (mode.getFrames() != null) {
            int[] indexes = mode.getFrames();
            OpenMatrix4f[] frames = new OpenMatrix4f[indexes.length];
            for (int i = 0; i < indexes.length; ++i) {
                frames[i] = this._genTextureMatrix((float)OpenMath.clamp(indexes[i], 0, total - 1) / (float)total);
            }
            return frames;
        }
        return new OpenMatrix4f[0];
    }

    private OpenMatrix4f _genTextureMatrix(float offset) {
        if (offset != 0.0f) {
            return OpenMatrix4f.createTranslateMatrix(0.0f, offset, 0.0f);
        }
        return IDENTITY;
    }
}

