/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.texture;

import java.util.IdentityHashMap;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.compatibility.client.AbstractSimpleTexture;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.texture.TextureManager.UnregisteringAPI;
import moe.plushie.armourers_workshop.core.client.texture.SmartTexture;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SmartTextureManager {
    private static final SmartTextureManager INSTANCE = new SmartTextureManager();
    protected final IdentityHashMap<Object, SmartTexture> textures = new IdentityHashMap();

    public static SmartTextureManager getInstance() {
        return INSTANCE;
    }

    public synchronized void start() {
    }

    public synchronized void stop() {
        this.textures.values().forEach(SmartTexture::unbind);
        this.textures.clear();
    }

    public void open(RenderType renderType) {
        SmartTexture texture = SmartTexture.of(renderType);
        if (texture != null) {
            texture.retain();
        }
    }

    public void close(RenderType renderType) {
        SmartTexture texture = SmartTexture.of(renderType);
        if (texture != null) {
            texture.release();
        }
    }

    public synchronized RenderType register(SkinTextureData provider, ISkinGeometryType type) {
        SmartTexture texture = this.textures.get(provider);
        if (texture == null) {
            texture = new SmartTexture(provider);
            this.textures.put(provider, texture);
        }
        return texture.getRenderType(type);
    }

    public TextureManager getTextureManager() {
        return Minecraft.m_91087_().m_91097_();
    }

    protected void uploadTexture(SmartTexture texture) {
        IResourceLocation location = texture.getLocation();
        this.getTextureManager().m_118495_(location.toLocation(), (AbstractTexture)AbstractSimpleTexture.create(location));
        if (ModConfig.Client.enableResourceDebug) {
            ModLog.debug("Registering Texture '{}'", location);
        }
    }

    protected void releaseTexture(SmartTexture texture) {
        IResourceLocation location = texture.getLocation();
        UnregisteringAPI.unregister(this.getTextureManager(), location.toLocation());
        if (ModConfig.Client.enableResourceDebug) {
            ModLog.debug("Unregistering Texture '{}'", location);
        }
    }
}

