/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.texture;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.other.SmartResourceManager;
import moe.plushie.armourers_workshop.core.client.texture.SmartTextureManager;
import moe.plushie.armourers_workshop.core.client.texture.TextureAnimationController;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureProperties;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.core.utils.OpenRandomSource;
import moe.plushie.armourers_workshop.core.utils.ReferenceCounted;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.Nullable;

public class SmartTexture
extends ReferenceCounted {
    private final IResourceLocation location;
    private final SkinTextureProperties properties;
    private final TextureAnimationController animationController;
    private final Map<IResourceLocation, ByteBuf> textureBuffers;
    private final Map<ISkinGeometryType, RenderType> bindingRenderTypes = new LinkedHashMap<ISkinGeometryType, RenderType>();

    public SmartTexture(SkinTextureData provider) {
        this.location = ModConstants.key("textures/dynamic/" + OpenRandomSource.nextInt(SmartTexture.class) + ".png");
        this.properties = provider.getProperties();
        this.textureBuffers = this.resolveTextureBuffers(this.location, provider);
        this.animationController = new TextureAnimationController(provider.getAnimation());
    }

    @Nullable
    public static SmartTexture of(RenderType renderType) {
        return DataContainer.getOrDefault(renderType, null);
    }

    @Override
    protected void init() {
        RenderSystem.safeCall(() -> {
            this.textureBuffers.forEach(SmartResourceManager.getInstance()::register);
            SmartTextureManager.getInstance().uploadTexture(this);
        });
    }

    @Override
    protected void dispose() {
        RenderSystem.safeCall(() -> {
            SmartTextureManager.getInstance().releaseTexture(this);
            this.textureBuffers.keySet().forEach(SmartResourceManager.getInstance()::unregister);
        });
    }

    public RenderType getRenderType(ISkinGeometryType type) {
        return this.bindingRenderTypes.computeIfAbsent(type, it -> {
            RenderType renderType = SkinRenderType.geometryFace(it, this.location, this.properties.isEmissive());
            DataContainer.set(renderType, this);
            return renderType;
        });
    }

    public IResourceLocation getLocation() {
        return this.location;
    }

    public TextureAnimationController getAnimationController() {
        return this.animationController;
    }

    public String toString() {
        return this.location.toString();
    }

    protected void unbind() {
        this.bindingRenderTypes.forEach((key, value) -> DataContainer.set(value, null));
        while (this.refCnt() > 0) {
            this.release();
        }
    }

    private Map<IResourceLocation, ByteBuf> resolveTextureBuffers(IResourceLocation location, SkinTextureData provider) {
        String path = FileUtils.removeExtension(location.getPath());
        TextureBufferBuilder builder = new TextureBufferBuilder(provider.getProperties());
        builder.addData(location, provider);
        for (SkinTextureData variant : provider.getVariants()) {
            if (variant.getProperties().isNormal()) {
                builder.addData(location.withPath(path + "_n.png"), variant);
            }
            if (!variant.getProperties().isSpecular()) continue;
            builder.addData(location.withPath(path + "_s.png"), variant);
        }
        return builder.build();
    }

    private static class TextureBufferBuilder {
        private final Map<IResourceLocation, ByteBuf> buffers = new LinkedHashMap<IResourceLocation, ByteBuf>();
        private final SkinTextureProperties parentProperties;

        private TextureBufferBuilder(SkinTextureProperties parentProperties) {
            this.parentProperties = parentProperties;
        }

        public void addData(IResourceLocation location, SkinTextureData provider) {
            this.buffers.put(location, provider.getBuffer());
            this.addMeta(location, provider.getProperties());
        }

        private void addMeta(IResourceLocation location, SkinTextureProperties properties) {
            boolean isClampToEdge;
            boolean isBlurFilter = properties.isBlurFilter() || this.parentProperties.isBlurFilter();
            boolean bl = isClampToEdge = properties.isClampToEdge() || this.parentProperties.isClampToEdge();
            if (!isBlurFilter && !isClampToEdge) {
                return;
            }
            String blur = String.valueOf(isBlurFilter);
            String clamp = String.valueOf(isClampToEdge);
            String meta = String.format("{\"texture\":{\"blur\":%s,\"clamp\":%s}}", blur, clamp);
            this.buffers.put(location.withPath(location.getPath() + ".mcmeta"), Unpooled.wrappedBuffer((byte[])meta.getBytes()));
        }

        public Map<IResourceLocation, ByteBuf> build() {
            return this.buffers;
        }
    }
}

