/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.IResourceManager;
import moe.plushie.armourers_workshop.core.data.color.TexturedPaintColor;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureModel;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BakedEntityTexture {
    private final HashMap<Integer, SkinPaintColor> allColors = new HashMap();
    private final HashMap<SkinPartType, HashMap<Integer, SkinPaintColor>> allParts = new HashMap();
    private final HashMap<SkinPartType, OpenRectangle3i> allBounds = new HashMap();
    private String model;
    private IResourceLocation resourceLocation;
    private boolean isSlimModel = false;
    private boolean isLoaded = false;

    public BakedEntityTexture() {
    }

    public BakedEntityTexture(IResourceLocation resourceLocation, boolean slim) {
        this.isSlimModel = slim;
        this.resourceLocation = resourceLocation;
        try {
            IResourceManager resourceManager = EnvironmentManager.getResourceManager();
            BufferedImage bufferedImage = ImageIO.read(resourceManager.readResource(resourceLocation).getInputStream());
            if (bufferedImage != null) {
                this.loadColors(bufferedImage.getWidth(), bufferedImage.getHeight(), slim, bufferedImage::getRGB);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadImage(NativeImage image, boolean slim) {
        this.loadColors(image.m_84982_(), image.m_85084_(), slim, (x, y) -> {
            int color = image.m_84985_(x, y);
            int red = color << 16 & 0xFF0000;
            int blue = color >> 16 & 0xFF;
            return color & 0xFF00FF00 | red | blue;
        });
    }

    private void loadColors(int width, int height, boolean slim, IColorAccessor accessor) {
        for (Map.Entry<SkinPartType, EntityTextureModel.Box> entry : EntityTextureModel.of(width, height, slim).entrySet()) {
            EntityTextureModel.Box box = entry.getValue();
            HashMap part = this.allParts.computeIfAbsent(entry.getKey(), k -> new HashMap());
            this.allBounds.put(entry.getKey(), box.getBounds());
            box.forEach((texture, x, y, z, dir) -> {
                int color = accessor.getRGB(texture.x(), texture.y());
                if (SkinPaintColor.isOpaque(color)) {
                    SkinPaintColor paintColor = TexturedPaintColor.of(color, SkinPaintTypes.NORMAL);
                    part.put(this.getPosKey(x, y, z, dir), paintColor);
                    this.allColors.put(this.getUVKey(texture.x(), texture.y()), paintColor);
                }
            });
        }
        this.isLoaded = true;
    }

    public SkinPaintColor getColor(OpenVector2i texturePos) {
        return this.getColor(texturePos.x(), texturePos.y());
    }

    public SkinPaintColor getColor(int u, int v) {
        return this.allColors.get(this.getUVKey(u, v));
    }

    public SkinPaintColor getColor(int x, int y, int z, OpenDirection dir, SkinPartType partType) {
        HashMap<Integer, SkinPaintColor> part = this.allParts.get(partType);
        OpenRectangle3i bounds = this.allBounds.get(partType);
        if (part == null || bounds == null) {
            return null;
        }
        x = OpenMath.clamp(x, bounds.minX(), bounds.maxX() - 1);
        y = OpenMath.clamp(y, bounds.minY(), bounds.maxY() - 1);
        z = OpenMath.clamp(z, bounds.minZ(), bounds.maxZ() - 1);
        return part.get(this.getPosKey(x, y, z, dir));
    }

    private int getPosKey(int x, int y, int z, OpenDirection dir) {
        return (dir.get3DDataValue() & 0xFF) << 24 | (z & 0xFF) << 16 | (y & 0xFF) << 8 | x & 0xFF;
    }

    private int getUVKey(int u, int v) {
        return (v & 0xFFFF) << 16 | u & 0xFFFF;
    }

    public IResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public void setResourceLocation(IResourceLocation location) {
        this.resourceLocation = location;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
        this.isSlimModel = Objects.equals(model, "slim");
    }

    public boolean isSlimModel() {
        return this.isSlimModel;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    static interface IColorAccessor {
        public int getRGB(int var1, int var2);
    }
}

