/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.sound;

import java.util.IdentityHashMap;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.client.AbstractSimpleSound;
import moe.plushie.armourers_workshop.compatibility.client.AbstractSoundManagerImpl;
import moe.plushie.armourers_workshop.core.client.sound.SmartSound;
import moe.plushie.armourers_workshop.core.skin.sound.SkinSoundData;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SmartSoundManager {
    private static final SmartSoundManager INSTANCE = new SmartSoundManager();
    protected final IdentityHashMap<Object, SmartSound> sounds = new IdentityHashMap();

    public static SmartSoundManager getInstance() {
        return INSTANCE;
    }

    public synchronized void start() {
    }

    public synchronized void stop() {
        this.sounds.values().forEach(SmartSound::unbind);
        this.sounds.clear();
    }

    public void open(SoundEvent soundEvent) {
        SmartSound sound = SmartSound.of(soundEvent);
        if (sound != null) {
            sound.retain();
        }
    }

    public void close(SoundEvent soundEvent) {
        SmartSound sound = SmartSound.of(soundEvent);
        if (sound != null) {
            sound.release();
        }
    }

    public synchronized SoundEvent register(SkinSoundData provider) {
        SmartSound sound = this.sounds.get(provider);
        if (sound == null) {
            sound = new SmartSound(provider);
            this.sounds.put(provider, sound);
        }
        return sound.getSoundEvent();
    }

    public AbstractSoundManagerImpl getSoundManager() {
        return (AbstractSoundManagerImpl)Minecraft.m_91087_().m_91106_();
    }

    protected void uploadSound(SmartSound sound) {
        String name = sound.getName();
        IResourceLocation location = sound.getLocation();
        IResourceLocation id = location.withPath(location.getPath().replaceFirst("sounds/(.+)\\.ogg", "$1"));
        this.getSoundManager().aw2$register(location.toLocation(), AbstractSimpleSound.create(id.toLocation(), name));
        if (ModConfig.Client.enableResourceDebug) {
            ModLog.debug("Registering Sound '{}'", location);
        }
    }

    protected void releaseSound(SmartSound sound) {
        IResourceLocation location = sound.getLocation();
        this.getSoundManager().aw2$unregister(location.toLocation());
        if (ModConfig.Client.enableResourceDebug) {
            ModLog.debug("Unregistering Sound '{}'", location);
        }
    }
}

