/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.plugin;

import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.data.DataContainerKey;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.init.ModDebugger;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class MinecartModelArmaturePlugin
extends ArmaturePlugin {
    private static final DataContainerKey<Boolean> IS_FLAPPED = DataContainerKey.of("isFlapped", Boolean.class, () -> false);

    public MinecartModelArmaturePlugin(ArmatureTransformerContext context) {
    }

    @Override
    public void activate(Entity entity, ArmaturePlugin.Context context) {
        AbstractMinecart minecart = (AbstractMinecart)entity;
        IPoseStack poseStack = context.getPoseStack();
        if (this.isFlapped(minecart, context.getPartialTicks(), context.getRenderData())) {
            poseStack.rotate(OpenVector3f.YP.rotationDegrees(180.0f));
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0f, -0.125f, 0.0f);
        ModDebugger.translate(poseStack);
        poseStack.rotate(OpenVector3f.YP.rotationDegrees(180.0f));
    }

    private boolean isFlapped(AbstractMinecart entity, float partialTicks, EntityRenderData renderData) {
        BlockState blockState;
        int k;
        int j;
        int i;
        Vec3 delta = entity.m_20184_();
        double dx = delta.m_7096_();
        double dz = delta.m_7094_();
        if (dx == 0.0 && dz == 0.0) {
            return renderData.getAssociatedObject(IS_FLAPPED);
        }
        Level level = PropertyProvider.getLevel((Entity)entity);
        if (level.m_8055_(new BlockPos(i = OpenMath.floori(OpenMath.lerp((double)partialTicks, entity.f_19790_, entity.m_20185_())), (j = OpenMath.floori(OpenMath.lerp((double)partialTicks, entity.f_19791_, entity.m_20186_()))) - 1, k = OpenMath.floori(OpenMath.lerp((double)partialTicks, entity.f_19792_, entity.m_20189_())))).m_204336_(BlockTags.f_13034_)) {
            --j;
        }
        if (!BaseRailBlock.m_49416_((BlockState)(blockState = level.m_8055_(new BlockPos(i, j, k))))) {
            return renderData.getAssociatedObject(IS_FLAPPED);
        }
        RailShape shape = (RailShape)blockState.m_61143_(((BaseRailBlock)blockState.m_60734_()).m_7978_());
        boolean result = this.isFlapped(shape, dx, dz);
        renderData.setAssociatedObject(IS_FLAPPED, result);
        return result;
    }

    private boolean isFlapped(RailShape shape, double x, double z) {
        double eps = 0.001;
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case RailShape.NORTH_WEST, RailShape.NORTH_EAST -> {
                if (z < -eps) {
                    yield true;
                }
                yield false;
            }
            case RailShape.SOUTH_EAST, RailShape.SOUTH_WEST -> {
                if (z > eps) {
                    yield true;
                }
                yield false;
            }
            case RailShape.NORTH_SOUTH -> {
                if (z < -eps) {
                    yield true;
                }
                yield false;
            }
            case RailShape.EAST_WEST -> {
                if (x < -eps) {
                    yield true;
                }
                yield false;
            }
            case RailShape.ASCENDING_EAST, RailShape.ASCENDING_WEST -> {
                if (x < -eps) {
                    yield true;
                }
                yield false;
            }
            case RailShape.ASCENDING_NORTH, RailShape.ASCENDING_SOUTH -> z < -eps;
        };
    }
}

