/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.patch;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.ModelView;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRendererContext;
import moe.plushie.armourers_workshop.core.client.other.EntitySlot;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EntityRenderPatch;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;

public class FallbackEntityRenderPatch<T extends Entity>
extends EntityRenderPatch<T> {
    private static final float SCALE = 0.0625f;
    private final BakedArmature armature;

    public FallbackEntityRenderPatch(BakedArmatureTransformer transformer, EntityRenderData renderData, EntityRendererContext context) {
        super(renderData, context);
        this.transformer = transformer;
        this.armature = BakedArmature.mutableBy(transformer.getArmature());
    }

    public static <T extends Entity> void activate(T entity, float partialTicks, int packedLight, PoseStack poseStackIn, EntityRenderer<?> entityRenderer, Consumer<FallbackEntityRenderPatch<T>> handler) {
        FallbackEntityRenderPatch._activate(FallbackEntityRenderPatch.class, entity, partialTicks, packedLight, poseStackIn, entityRenderer, handler, (renderData, rendererStorage) -> {
            BakedArmatureTransformer transformer = rendererStorage.getTransformer(null);
            if (transformer != null) {
                return new FallbackEntityRenderPatch(transformer, renderData, rendererStorage);
            }
            return null;
        });
    }

    public static <T extends Entity> void apply(T entity, PoseStack poseStackIn, MultiBufferSource buffersIn, Consumer<FallbackEntityRenderPatch<T>> handler) {
        FallbackEntityRenderPatch._apply(FallbackEntityRenderPatch.class, entity, poseStackIn, buffersIn, handler);
    }

    public static <T extends Entity> void deactivate(T entity, Consumer<FallbackEntityRenderPatch<T>> handler) {
        FallbackEntityRenderPatch._deactivate(FallbackEntityRenderPatch.class, entity, handler);
    }

    @Override
    protected void onApply(Entity entity, PoseStack poseStackIn, MultiBufferSource bufferSourceIn) {
        IPoseStack poseStack = this.pluginContext.getPoseStack();
        EntityRenderData renderData = this.pluginContext.getRenderData();
        poseStack.pushPose();
        this.transformer.activate(entity, this.pluginContext);
        this.transformer.applyTo(this.armature);
        poseStack.scale(-0.0625f, -0.0625f, 0.0625f);
        this.renderingContext.setOverlay(this.pluginContext.getOverlay());
        this.renderingContext.setLightmap(this.pluginContext.getLightmap());
        this.renderingContext.setPartialTicks(this.pluginContext.getPartialTicks());
        this.renderingContext.setAnimationTicks(this.pluginContext.getAnimationTicks());
        this.renderingContext.setPoseStack(this.pluginContext.getPoseStack());
        this.renderingContext.setBufferSource(AbstractBufferSource.wrap(bufferSourceIn));
        this.renderingContext.setModelViewStack(AbstractPoseStack.create(ModelView.getExtendedModelViewStack(RenderSystem.class)));
        for (EntitySlot entry : renderData.getItemSkins()) {
            this.renderingContext.setOverlay(entry.getOverrideOverlay(entity));
            this.renderingContext.setItemSource(SkinItemSource.create(entry.getRenderPriority(), entry.getItemStack()));
            BakedSkin bakedSkin = entry.getSkin();
            bakedSkin.setupAnim(entity, this.armature, this.renderingContext);
            SkinPaintScheme paintScheme = bakedSkin.resolve(entity, entry.getPaintScheme());
            SkinRenderer.render(entity, this.armature, bakedSkin, paintScheme, this.renderingContext);
        }
        poseStack.popPose();
    }
}

