/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.patch;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.core.armature.core.DefaultArmaturePluginContext;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRendererContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;

public abstract class EntityRenderPatch<T extends Entity> {
    protected final int version;
    protected final SkinRenderContext renderingContext = new SkinRenderContext();
    protected final DefaultArmaturePluginContext pluginContext = new DefaultArmaturePluginContext();
    protected BakedArmatureTransformer transformer;

    public EntityRenderPatch(EntityRenderData renderData, EntityRendererContext context) {
        this.version = context.getVersion();
        this.pluginContext.setRenderData(renderData);
        this.renderingContext.setRenderData(renderData);
    }

    protected static <T extends Entity, P extends EntityRenderPatch<? super T>> void _activate(Class<?> clazz, T entity, float partialTicks, int packedLight, PoseStack poseStackIn, EntityRenderer<?> entityRenderer, Consumer<P> handler, Factory<? extends T> factory) {
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        EntityRenderPatch renderPatch = renderData.getRenderPatch();
        EntityRendererContext rendererContext = EntityRendererContext.of(entityRenderer);
        if (!clazz.isInstance(renderPatch) || !renderPatch.isValid(rendererContext)) {
            EntityRenderPatch<? extends T> renderPatch1 = factory.create(renderData, rendererContext);
            renderPatch = (EntityRenderPatch)Objects.unsafeCast(renderPatch1);
            renderData.setRenderPatch(renderPatch);
            if (renderPatch == null) {
                return;
            }
        }
        renderPatch.onInit(entity, partialTicks, packedLight, poseStackIn, entityRenderer);
        renderPatch.onActivate(entity);
        if (handler != null) {
            handler.accept((EntityRenderPatch)Objects.unsafeCast(renderPatch));
        }
    }

    protected static <T extends Entity, P extends EntityRenderPatch<? super T>> void _apply(Class<?> clazz, T entity, PoseStack poseStackIn, MultiBufferSource bufferSourceIn, Consumer<P> handler) {
        EntityRenderPatch<? super Entity> renderPatch;
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null && clazz.isInstance(renderPatch = renderData.getRenderPatch())) {
            if (handler != null) {
                handler.accept((EntityRenderPatch)Objects.unsafeCast(renderPatch));
            }
            renderPatch.onApply(entity, poseStackIn, bufferSourceIn);
        }
    }

    protected static <T extends Entity, P extends EntityRenderPatch<? super T>> void _deactivate(Class<?> clazz, T entity, Consumer<P> handler) {
        EntityRenderPatch<? super Entity> renderPatch;
        EntityRenderData renderData = EntityRenderData.of(entity);
        if (renderData != null && clazz.isInstance(renderPatch = renderData.getRenderPatch())) {
            renderPatch.onDeactivate(entity);
            if (handler != null) {
                handler.accept((EntityRenderPatch)Objects.unsafeCast(renderPatch));
            }
        }
    }

    protected void onInit(T entity, float partialTicks, int packedLight, PoseStack poseStackIn, EntityRenderer<?> entityRenderer) {
        this.pluginContext.setPartialTicks(partialTicks);
        this.pluginContext.setAnimationTicks(TickUtils.animationTicks());
        this.pluginContext.setLightmap(packedLight);
        this.pluginContext.setPoseStack(AbstractPoseStack.wrap(poseStackIn));
    }

    protected void onActivate(T entity) {
        if (this.transformer != null) {
            this.transformer.prepare((Entity)entity, this.pluginContext);
        }
    }

    protected void onApply(T entity, PoseStack poseStackIn, MultiBufferSource bufferSourceIn) {
        if (this.transformer != null) {
            this.transformer.activate((Entity)entity, this.pluginContext);
        }
    }

    protected void onDeactivate(T entity) {
        if (this.transformer != null) {
            this.transformer.deactivate((Entity)entity, this.pluginContext);
        }
    }

    public boolean isValid(EntityRendererContext context) {
        return this.version == context.getVersion();
    }

    public BakedArmatureTransformer getTransformer() {
        return this.transformer;
    }

    public DefaultArmaturePluginContext getPluginContext() {
        return this.pluginContext;
    }

    public SkinRenderContext getRenderingContext() {
        return this.renderingContext;
    }

    @FunctionalInterface
    public static interface Factory<T extends Entity> {
        public EntityRenderPatch<T> create(EntityRenderData var1, EntityRendererContext var2);
    }
}

