/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShaderVertexMerger {
    private int maxVertexCount = 0;
    private final ArrayList<ShaderVertexGroup> sortedGroups = new ArrayList();
    private final HashMap<RenderType, ShaderVertexGroup> pending = new HashMap();

    public void add(ShaderVertexObject pass) {
        ShaderVertexGroup group = this.pending.get(pass.getType());
        if (group == null) {
            group = this.addAndSort(pass.getType());
            this.pending.put(pass.getType(), group);
        }
        group.add(pass);
        this.maxVertexCount = Math.max(this.maxVertexCount, pass.getTotal());
    }

    public void forEach(Consumer<ShaderVertexGroup> consumer) {
        for (ShaderVertexGroup group : this.sortedGroups) {
            if (group.isEmpty()) continue;
            group.maxVertexCount = this.maxVertexCount;
            consumer.accept(group);
        }
    }

    public void prepare() {
    }

    public void reset() {
        this.pending.forEach((? super K renderType, ? super V group) -> group.clear());
        this.maxVertexCount = 0;
    }

    public void clear() {
        this.sortedGroups.clear();
        this.pending.clear();
    }

    public int size() {
        int total = 0;
        for (ShaderVertexGroup group : this.pending.values()) {
            total += group.size();
        }
        return total;
    }

    public boolean isEmpty() {
        return this.maxVertexCount == 0;
    }

    private ShaderVertexGroup addAndSort(RenderType type) {
        ShaderVertexGroup group = new ShaderVertexGroup(type);
        this.sortedGroups.add(group);
        this.sortedGroups.sort(Comparator.comparing(this::getRenderOrder));
        return group;
    }

    private int getRenderOrder(ShaderVertexGroup group) {
        int index = SkinRenderType.getPriority(group.getRenderType());
        if (index > 0) {
            return index;
        }
        return Integer.MAX_VALUE;
    }
}

