/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import moe.plushie.armourers_workshop.core.client.shader.ShaderUniform;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL20;

@OnlyIn(value=Dist.CLIENT)
public class ShaderUniforms {
    private static ShaderUniforms INSTANCE = new ShaderUniforms();
    private final Int2ObjectMap<State> states = new Int2ObjectOpenHashMap();

    public static ShaderUniforms getInstance() {
        return INSTANCE;
    }

    public static void begin() {
    }

    public static void end() {
        ShaderUniforms instance = ShaderUniforms.getInstance();
        int currentProgram = GL20.glGetInteger((int)35725);
        instance.states.forEach((programId, state) -> {
            if (!state.isChanged()) {
                return;
            }
            if (currentProgram != programId) {
                GL20.glUseProgram((int)programId);
            }
            state.reset();
            if (currentProgram != programId) {
                GL20.glUseProgram((int)currentProgram);
            }
        });
    }

    public static void clear() {
        if (ShaderUniforms.getInstance().states.isEmpty()) {
            return;
        }
        INSTANCE = new ShaderUniforms();
        ModLog.debug("reset all uniforms from shader changes", new Object[0]);
    }

    public void apply(int programId) {
        if (programId == 0) {
            return;
        }
        State state = (State)this.states.computeIfAbsent(programId, State::new);
        if (!state.isEmpty()) {
            state.apply();
        }
    }

    private static class State {
        private final List<ShaderUniform> uniforms;
        private List<ShaderUniform> changes;

        public State(int program) {
            ShaderUniform.Loader loader = new ShaderUniform.Loader(program);
            this.uniforms = loader.uniforms;
        }

        public void apply() {
            if (this.changes == null) {
                this.uniforms.forEach(ShaderUniform::push);
                this.changes = this.uniforms;
            }
            this.uniforms.forEach(ShaderUniform::apply);
        }

        public void reset() {
            if (this.changes != null) {
                this.uniforms.forEach(ShaderUniform::pop);
                this.changes = null;
            }
        }

        public boolean isEmpty() {
            return this.uniforms.isEmpty();
        }

        public boolean isChanged() {
            return this.changes != null;
        }
    }
}

