/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import java.util.List;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.ModelView;
import moe.plushie.armourers_workshop.core.armature.core.DefaultArmaturePluginContext;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntitySlot;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.BlockEntityRenderPatch;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HologramProjectorBlockRenderer<T extends HologramProjectorBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    public HologramProjectorBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    @Override
    public void render(T entity, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        if (!((HologramProjectorBlockEntity)entity).isPowered()) {
            return;
        }
        BlockEntityRenderData renderData = BlockEntityRenderData.of(entity);
        if (renderData == null) {
            return;
        }
        renderData.tick((BlockEntity)entity);
        List<EntitySlot> renderingTasks = renderData.getAllSkins();
        if (renderingTasks.isEmpty()) {
            return;
        }
        float f = 0.0625f;
        int overLight = light;
        if (((HologramProjectorBlockEntity)entity).isOverrideLight()) {
            overLight = 0xF000F0;
        }
        BlockState blockState = entity.m_58900_();
        BlockEntityRenderPatch<? super BlockEntity> renderPatch = renderData.getRenderPatch();
        MannequinEntity mannequinEntity = PlaceholderManager.MANNEQUIN.get();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.rotate(((HologramProjectorBlockEntity)entity).getRenderRotations(blockState));
        poseStack.translate(0.0f, 0.5f, 0.0f);
        poseStack.scale(f, f, f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        renderPatch.activate((BlockEntity)entity, partialTicks, overLight, overlay, poseStack);
        DefaultArmaturePluginContext pluginContext = renderPatch.getPluginContext();
        SkinRenderContext renderingContext = renderPatch.getRenderingContext();
        renderingContext.setOverlay(pluginContext.getOverlay());
        renderingContext.setLightmap(pluginContext.getLightmap());
        renderingContext.setPartialTicks(pluginContext.getPartialTicks());
        renderingContext.setAnimationTicks(pluginContext.getAnimationTicks());
        renderingContext.setPoseStack(poseStack);
        renderingContext.setBufferSource(bufferSource);
        renderingContext.setModelViewStack(AbstractPoseStack.create(ModelView.getExtendedModelViewStack(RenderSystem.class)));
        for (EntitySlot entry : renderingTasks) {
            SkinItemSource itemSource = SkinItemSource.create(entry.getItemStack());
            BakedSkin bakedSkin = entry.getSkin();
            BakedArmature bakedArmature = BakedArmature.defaultBy(bakedSkin.getType());
            OpenRectangle3f rect = bakedSkin.getRenderBounds();
            renderingContext.setItemSource(itemSource);
            renderingContext.setColorScheme(entry.getPaintScheme());
            this.apply(entity, rect, renderingContext.getAnimationTicks(), poseStack, bufferSource);
            bakedSkin.setupAnim((Entity)mannequinEntity, bakedArmature, renderingContext);
            SkinPaintScheme paintScheme = bakedSkin.resolve((Entity)mannequinEntity, entry.getPaintScheme());
            SkinRenderer.render((Entity)mannequinEntity, bakedArmature, bakedSkin, paintScheme, renderingContext);
        }
        poseStack.popPose();
        if (ModDebugger.hologramProjector) {
            BlockPos pos = entity.m_58899_();
            poseStack.pushPose();
            poseStack.translate(-pos.m_123341_(), -pos.m_123342_(), -pos.m_123343_());
            ShapeTesselator.stroke((IRectangle3f)((HologramProjectorBlockEntity)entity).getRenderShape(blockState), UIColor.ORANGE, poseStack, bufferSource);
            poseStack.popPose();
        }
        renderPatch.deactivate((BlockEntity)entity);
    }

    private void apply(T entity, OpenRectangle3f rect, double animationTime, IPoseStack poseStack, IBufferSource bufferSource) {
        OpenVector3f angle = ((HologramProjectorBlockEntity)entity).getModelAngle();
        OpenVector3f offset = ((HologramProjectorBlockEntity)entity).getModelOffset();
        OpenVector3f rotationOffset = ((HologramProjectorBlockEntity)entity).getRotationOffset();
        OpenVector3f rotationSpeed = ((HologramProjectorBlockEntity)entity).getRotationSpeed();
        float rotX = angle.x();
        float speedX = rotationSpeed.x() / 1000.0f;
        if (speedX != 0.0f) {
            rotX += (float)(animationTime % (double)speedX / (double)speedX * 360.0);
        }
        float rotY = angle.y();
        float speedY = rotationSpeed.y() / 1000.0f;
        if (speedY != 0.0f) {
            rotY += (float)(animationTime % (double)speedY / (double)speedY * 360.0);
        }
        float rotZ = angle.z();
        float speedZ = rotationSpeed.z() / 1000.0f;
        if (speedZ != 0.0f) {
            rotZ += (float)(animationTime % (double)speedZ / (double)speedZ * 360.0);
        }
        float scale = ((HologramProjectorBlockEntity)entity).getModelScale();
        poseStack.scale(scale, scale, scale);
        if (((HologramProjectorBlockEntity)entity).isOverrideOrigin()) {
            poseStack.translate(0.0f, -rect.maxY(), 0.0f);
        }
        poseStack.translate(-offset.x(), -offset.y(), offset.z());
        if (((HologramProjectorBlockEntity)entity).shouldShowRotationPoint()) {
            ShapeTesselator.stroke(-1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, UIColor.MAGENTA, poseStack, bufferSource);
        }
        if (ModDebugger.hologramProjector) {
            ShapeTesselator.vector(OpenVector3f.ZERO, 128.0f, poseStack, bufferSource);
        }
        poseStack.rotate(new OpenQuaternionf(rotX, -rotY, rotZ, true));
        poseStack.translate(rotationOffset.x(), -rotationOffset.y(), rotationOffset.z());
        if (ModDebugger.hologramProjector) {
            ShapeTesselator.vector(OpenVector3f.ZERO, 128.0f, poseStack, bufferSource);
        }
    }

    public int m_142163_() {
        return 272;
    }
}

