/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.vertex.VertexConsumer;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3i;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.data.MannequinHitResult;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HighlightPlacementRenderer {
    public static void renderBlock(ItemStack itemStack, Player player, BlockHitResult traceResult, Camera renderInfo, IPoseStack poseStack, IBufferSource bufferSource) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.getType() != SkinTypes.BLOCK) {
            return;
        }
        poseStack.pushPose();
        float f = 0.0625f;
        Vec3 origin = renderInfo.m_90583_();
        SkinBlockPlaceContext context = new SkinBlockPlaceContext(player, InteractionHand.MAIN_HAND, itemStack, traceResult);
        BlockPos location = context.m_8083_();
        poseStack.translate((float)location.m_123341_() - (float)origin.m_7096_(), (float)location.m_123342_() - (float)origin.m_7098_(), (float)location.m_123343_() - (float)origin.m_7094_());
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.scale(f, f, f);
        for (SkinBlockPlaceContext.Part part : context.getParts()) {
            BlockPos pos = part.getOffset();
            UIColor color = UIColor.RED;
            if (context.canPlace(part)) {
                color = UIColor.WHITE;
            }
            poseStack.pushPose();
            poseStack.translate((float)pos.m_123341_() * 16.0f, (float)pos.m_123342_() * 16.0f, (float)pos.m_123343_() * 16.0f);
            ShapeTesselator.stroke((IRectangle3i)part.getShape(), color, poseStack, bufferSource);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public static void renderEntity(Player player, BlockHitResult traceResult, Camera renderInfo, IPoseStack poseStack, IBufferSource bufferSource) {
        Vec3 origin = renderInfo.m_90583_();
        MannequinHitResult target = MannequinHitResult.test(player, origin, traceResult.m_82450_(), traceResult.m_82425_());
        poseStack.pushPose();
        Vec3 location = target.m_82450_();
        poseStack.translate((float)(location.m_7096_() - origin.m_7096_()), (float)(location.m_7098_() - origin.m_7098_()), (float)(location.m_7094_() - origin.m_7094_()));
        poseStack.rotate(OpenVector3f.YP.rotationDegrees(-target.getRotation()));
        MannequinModel<?> model = SkinItemRenderer.getInstance().getMannequinModel();
        if (model != null) {
            float f = target.getScale() * 0.9375f;
            MultiBufferSource buffers1 = AbstractBufferSource.unwrap(bufferSource);
            VertexConsumer builder = buffers1.m_6299_(SkinRenderType.HIGHLIGHTED_ENTITY_LINES);
            poseStack.pushPose();
            poseStack.scale(f, f, f);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(0.0f, -1.501f, 0.0f);
            model.renderToBuffer(AbstractPoseStack.unwrap(poseStack), builder, 0xF000F0, OverlayTexture.f_118083_, -1);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

