/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.HashMap;
import moe.plushie.armourers_workshop.api.client.IBufferBuilder;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IRenderAttachable;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferBuilder;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderSheet;
import moe.plushie.armourers_workshop.compatibility.client.AbstractShader;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentBufferCompiler;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderObjectBuilder;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexMerger;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkinVertexBufferBuilder
implements IBufferSource {
    private static SkinVertexBufferBuilder INSTANCE;
    protected final HashMap<BakedSkin, SkinRenderObjectBuilder> skinBufferBuilders = new HashMap();
    protected final HashMap<BakedSkin, SkinRenderObjectBuilder> startedSkinBufferBuilders = new HashMap();
    protected final HashMap<RenderType, AbstractBufferBuilder> userBufferBuilders = new HashMap();
    protected final HashMap<RenderType, AbstractBufferBuilder> startedUserBufferBuilders = new HashMap();
    protected final Pipeline pipeline = new Pipeline();
    protected final Pipeline translucentPipeline = new Pipeline();
    protected final Pipeline outlinePipeline = new Pipeline();

    public static SkinVertexBufferBuilder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SkinVertexBufferBuilder();
        }
        return INSTANCE;
    }

    public static SkinVertexBufferBuilder getBuffer(IBufferSource bufferSource) {
        SkinVertexBufferBuilder builder = SkinVertexBufferBuilder.getInstance();
        SkinVertexBufferBuilder.attach(bufferSource, AbstractRenderSheet.solidBlockSheet(), builder::endBatch);
        if (bufferSource == AbstractBufferSource.outline()) {
            SkinVertexBufferBuilder.attach(bufferSource, AbstractRenderSheet.outlineBlockSheet(), builder::endOutlineBatch);
        }
        return builder;
    }

    private static void attach(IBufferSource bufferSource, RenderType renderType, Runnable action) {
        IVertexConsumer buffer = bufferSource.getBuffer(renderType);
        if (renderType instanceof IRenderAttachable) {
            IRenderAttachable attachable = (IRenderAttachable)renderType;
            attachable.attachRenderTask(buffer, action);
        }
    }

    public static void clearAllCache() {
        SkinVertexBufferBuilder builder = SkinVertexBufferBuilder.getInstance();
        builder.skinBufferBuilders.clear();
        builder.userBufferBuilders.clear();
        builder.pipeline.clear();
        builder.translucentPipeline.clear();
        builder.outlinePipeline.clear();
        ConcurrentBufferCompiler.clearAllCache();
    }

    @Override
    @NotNull
    public IBufferBuilder getBuffer(@NotNull RenderType renderType) {
        AbstractBufferBuilder buffer = this.startedUserBufferBuilders.get(renderType);
        if (buffer != null) {
            return buffer;
        }
        buffer = this.userBufferBuilders.computeIfAbsent(renderType, k -> new AbstractBufferBuilder(k.m_110507_()));
        buffer.begin(renderType);
        this.startedUserBufferBuilders.put(renderType, buffer);
        return buffer;
    }

    public SkinRenderObjectBuilder getBuffer(@NotNull BakedSkin skin) {
        SkinRenderObjectBuilder bufferBuilder = this.startedSkinBufferBuilders.get(skin);
        if (bufferBuilder != null) {
            return bufferBuilder;
        }
        bufferBuilder = this.skinBufferBuilders.computeIfAbsent(skin, SkinRenderObjectBuilder::new);
        this.startedSkinBufferBuilders.put(skin, bufferBuilder);
        return bufferBuilder;
    }

    @Override
    public void endBatch() {
        if (!this.startedSkinBufferBuilders.isEmpty()) {
            for (SkinRenderObjectBuilder builder : this.startedSkinBufferBuilders.values()) {
                builder.endBatch(this::uploadPass);
            }
            this.startedSkinBufferBuilders.clear();
        }
        this.pipeline.end();
        if (!this.startedUserBufferBuilders.isEmpty()) {
            this.startedUserBufferBuilders.forEach(AbstractBufferBuilder::upload);
            this.startedUserBufferBuilders.clear();
        }
    }

    public void endTranslucentBatch() {
        this.translucentPipeline.end();
    }

    public void endOutlineBatch() {
        this.outlinePipeline.end();
    }

    private void uploadPass(ShaderVertexObject pass) {
        if (pass.isOutline()) {
            this.outlinePipeline.add(pass);
        } else {
            this.pipeline.add(pass);
        }
    }

    public static class Pipeline {
        private final AbstractShader shader = new AbstractShader();
        private final ShaderVertexMerger merger = new ShaderVertexMerger();

        public void add(ShaderVertexObject pass) {
            this.merger.add(pass);
        }

        public void end() {
            if (this.merger.isEmpty()) {
                return;
            }
            this.merger.prepare();
            this.shader.begin();
            this.merger.forEach(group -> this.shader.apply((ShaderVertexGroup)group, () -> group.forEach(this.shader::render)));
            this.shader.end();
            this.merger.reset();
        }

        public void clear() {
            this.merger.reset();
            this.merger.clear();
        }
    }
}

