/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.api.client.IRenderTypeBuilder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryType;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderType;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderFormat;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.data.DataContainerKey;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class SkinRenderType
implements IRenderTypeBuilder {
    private static final DataContainerKey<SkinRenderFormat> FORMAT = DataContainerKey.of("format", SkinRenderFormat.class);
    private static final DataContainerKey<Boolean> USING_INDEX = DataContainerKey.of("usingIndex", Boolean.class, () -> true);
    public static final RenderType BLIT_COLOR = SkinRenderType._builder(SkinRenderFormat.BLIT_MASK).build("aw_blit_color");
    public static final RenderType BLIT_MASK = SkinRenderType._builder(SkinRenderFormat.BLIT_MASK).writeMask(IRenderTypeBuilder.WriteMask.NONE).build("aw_blit_mask");
    public static final RenderType BLIT_IMAGE = SkinRenderType._builder(SkinRenderFormat.GUI_IMAGE).build("aw_blit_image");
    public static final RenderType GUI_COLOR = SkinRenderType._builder(SkinRenderFormat.GUI_COLOR).transparency(IRenderTypeBuilder.Transparency.DEFAULT).build("aw_gui_color");
    public static final RenderType GUI_IMAGE = SkinRenderType._builder(SkinRenderFormat.GUI_IMAGE).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).build("aw_gui_image");
    public static final RenderType GUI_HIGHLIGHTED_TEXT = SkinRenderType._builder(SkinRenderFormat.GUI_HIGHLIGHTED_TEXT).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).colorLogic(IRenderTypeBuilder.ColorLogic.OR_REVERSE).depthTest(IRenderTypeBuilder.DepthTest.NONE).build("aw_highlighted_text");
    public static final RenderType IMAGE_MAGIC = SkinRenderType._texture(ModTextures.CIRCLE).writeMask(IRenderTypeBuilder.WriteMask.COLOR_WRITE).sortOnUpload().build("aw_image_magic");
    public static final RenderType IMAGE_GUIDE = SkinRenderType._texture(ModTextures.GUIDES).polygonOffset(-1.0f, -10.0f).build("aw_image_guide");
    public static final RenderType IMAGE_MARKER = SkinRenderType._texture2(ModTextures.MARKERS).polygonOffset(-1.0f, -10.0f).cull().build("aw_image_marker");
    public static final RenderType HIGHLIGHTED_LINES = SkinRenderType._line(2.0f).depthTest(IRenderTypeBuilder.DepthTest.NONE).build("aw_lines_ndt");
    public static final RenderType HIGHLIGHTED_ENTITY_LINES = SkinRenderType._entityHighlight(ModTextures.MANNEQUIN_HIGHLIGHT).build("aw_entity_lines");
    public static final RenderType PLAYER_CUTOUT = SkinRenderType.entityCutout(ModTextures.MANNEQUIN_DEFAULT);
    public static final RenderType PLAYER_CUTOUT_NO_CULL = SkinRenderType.entityCutoutNoCull(ModTextures.MANNEQUIN_DEFAULT);
    public static final RenderType PLAYER_TRANSLUCENT = SkinRenderType.entityTranslucentCull(ModTextures.MANNEQUIN_DEFAULT);
    public static final RenderType BLOCK_CUBE = SkinRenderType._block(ModTextures.BLOCK_CUBE).build("aw_block_cube");
    public static final RenderType BLOCK_CUBE_GLASS = SkinRenderType._block(ModTextures.BLOCK_CUBE_GLASS).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).sortOnUpload().build("aw_block_cube_glass");
    public static final RenderType BLOCK_CUBE_GLASS_UNSORTED = SkinRenderType._block(ModTextures.BLOCK_CUBE_GLASS).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).build("aw_block_cube_glass_unsorted");
    public static final RenderType BLOCK_EARTH = SkinRenderType._builder(SkinRenderFormat.SKIN_BLOCK_FACE_LIGHTING_TRANSLUCENT).texture(ModTextures.EARTH).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).target(IRenderTypeBuilder.Target.TRANSLUCENT).cull().build("aw_block_earth");
    public static final RenderType BLOCK_FACE_SOLID = SkinRenderType._blockFace(SkinRenderFormat.SKIN_BLOCK_FACE_SOLID).texture(ModTextures.CUBE).build("aw_face_sold");
    public static final RenderType BLOCK_FACE_LIGHTING = SkinRenderType._blockFace(SkinRenderFormat.SKIN_BLOCK_FACE_LIGHTING).texture(ModTextures.LIGHTING_CUBE).build("aw_lighting_quad_face");
    public static final RenderType BLOCK_FACE_TRANSLUCENT = SkinRenderType._blockFace(SkinRenderFormat.SKIN_BLOCK_FACE_TRANSLUCENT).texture(ModTextures.CUBE).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).target(IRenderTypeBuilder.Target.TRANSLUCENT).build("aw_translucent_quad_face");
    public static final RenderType BLOCK_FACE_LIGHTING_TRANSLUCENT = SkinRenderType._blockFace(SkinRenderFormat.SKIN_BLOCK_FACE_LIGHTING_TRANSLUCENT).texture(ModTextures.LIGHTING_CUBE).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).target(IRenderTypeBuilder.Target.TRANSLUCENT).build("aw_translucent_lighting_quad_face");
    private static final RenderType LINES = SkinRenderType._line(1.0f).build("aw_lines");
    private static final RenderType LINE_STRIP = SkinRenderType._builder(SkinRenderFormat.LINE_STRIP).lineWidth(1.0f).build("aw_line_strip");
    private static final ConcurrentHashMap<String, RenderType> CUSTOM_FACE_SOLID_VARIANTS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, RenderType> CUSTOM_FACE_LIGHTING_VARIANTS = new ConcurrentHashMap();
    private static final RenderType[] RENDER_ORDERING_FACES = new RenderType[]{BLOCK_FACE_SOLID, BLOCK_FACE_LIGHTING, BLOCK_FACE_TRANSLUCENT, BLOCK_FACE_LIGHTING_TRANSLUCENT};

    public static RenderType by(ISkinGeometryType geometryType) {
        if (geometryType == SkinGeometryTypes.BLOCK_GLASS) {
            return BLOCK_FACE_TRANSLUCENT;
        }
        if (geometryType == SkinGeometryTypes.BLOCK_GLASS_GLOWING) {
            return BLOCK_FACE_LIGHTING_TRANSLUCENT;
        }
        if (geometryType == SkinGeometryTypes.BLOCK_GLOWING) {
            return BLOCK_FACE_LIGHTING;
        }
        return BLOCK_FACE_SOLID;
    }

    public static RenderType customFace(String name, SkinRenderFormat format, IResourceLocation texture, boolean isGrowing, boolean isCull, boolean isUseIndex) {
        ConcurrentHashMap<String, RenderType> variants = CUSTOM_FACE_SOLID_VARIANTS;
        if (isGrowing) {
            variants = CUSTOM_FACE_LIGHTING_VARIANTS;
        }
        String key = String.format("%s/%s", name, texture.getPath());
        return variants.computeIfAbsent(key, it -> {
            IRenderTypeBuilder builder = SkinRenderType._customFace(format).texture(texture);
            if (isCull) {
                builder = builder.cull();
            }
            if (!isUseIndex) {
                builder = builder.property(USING_INDEX, false);
            }
            return builder.build((String)it);
        });
    }

    public static RenderType geometryFace(ISkinGeometryType type, IResourceLocation texture, boolean isGrowing) {
        if (isGrowing) {
            if (type == SkinGeometryTypes.CUBE) {
                return SkinRenderType.customFace("aw_cube_lighting", SkinRenderFormat.SKIN_CUBE_FACE_LIGHTING, texture, true, false, true);
            }
            if (type == SkinGeometryTypes.CUBE_CULL) {
                return SkinRenderType.customFace("aw_cube_lighting_cull", SkinRenderFormat.SKIN_CUBE_FACE_LIGHTING, texture, true, true, true);
            }
            if (type == SkinGeometryTypes.MESH) {
                return SkinRenderType.customFace("aw_mesh_lighting", SkinRenderFormat.SKIN_MESH_FACE_LIGHTING, texture, true, false, false);
            }
            if (type == SkinGeometryTypes.MESH_CULL) {
                return SkinRenderType.customFace("aw_mesh_lighting_cull", SkinRenderFormat.SKIN_MESH_FACE_LIGHTING, texture, true, true, false);
            }
        } else {
            if (type == SkinGeometryTypes.CUBE) {
                return SkinRenderType.customFace("aw_cube_solid", SkinRenderFormat.SKIN_CUBE_FACE, texture, false, false, true);
            }
            if (type == SkinGeometryTypes.CUBE_CULL) {
                return SkinRenderType.customFace("aw_cube_solid_cull", SkinRenderFormat.SKIN_CUBE_FACE, texture, false, true, true);
            }
            if (type == SkinGeometryTypes.MESH) {
                return SkinRenderType.customFace("aw_mesh_solid", SkinRenderFormat.SKIN_MESH_FACE, texture, false, false, false);
            }
            if (type == SkinGeometryTypes.MESH_CULL) {
                return SkinRenderType.customFace("aw_mesh_solid_cull", SkinRenderFormat.SKIN_MESH_FACE, texture, false, true, false);
            }
        }
        return SkinRenderType.by(type);
    }

    public static RenderType lines() {
        return LINES;
    }

    public static RenderType lineStrip() {
        return LINE_STRIP;
    }

    public static RenderType entityCutout(IResourceLocation texture) {
        return SkinRenderType._entity(SkinRenderFormat.ENTITY_CUTOUT, texture).cull().build("aw_player_solid");
    }

    public static RenderType entityCutoutNoCull(IResourceLocation texture) {
        return SkinRenderType._entity(SkinRenderFormat.ENTITY_CUTOUT_NO_CULL, texture).build("aw_player_cutout");
    }

    public static RenderType entityTranslucentCull(IResourceLocation texture) {
        return SkinRenderType._entity(SkinRenderFormat.ENTITY_TRANSLUCENT, texture).cull().transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).build("aw_player_translucent");
    }

    public static int getPriority(RenderType renderType) {
        int index = 1;
        for (RenderType target : RENDER_ORDERING_FACES) {
            if (target == renderType) {
                return index;
            }
            ++index;
        }
        ++index;
        if (CUSTOM_FACE_SOLID_VARIANTS.containsValue(renderType)) {
            return index;
        }
        ++index;
        if (CUSTOM_FACE_LIGHTING_VARIANTS.containsValue(renderType)) {
            return index;
        }
        return 0;
    }

    public static boolean isGrowing(RenderType renderType) {
        if (renderType == BLOCK_FACE_LIGHTING || renderType == BLOCK_FACE_LIGHTING_TRANSLUCENT) {
            return true;
        }
        if (renderType == BLOCK_FACE_SOLID || renderType == BLOCK_FACE_TRANSLUCENT) {
            return false;
        }
        return CUSTOM_FACE_LIGHTING_VARIANTS.containsValue(renderType);
    }

    public static boolean isTranslucent(RenderType renderType) {
        if (renderType == BLOCK_FACE_TRANSLUCENT || renderType == BLOCK_FACE_LIGHTING_TRANSLUCENT) {
            return true;
        }
        if (renderType == BLOCK_FACE_SOLID || renderType == BLOCK_FACE_LIGHTING) {
            return false;
        }
        return false;
    }

    public static boolean isUsingIndex(RenderType renderType) {
        return DataContainer.get(renderType, USING_INDEX);
    }

    private static IRenderTypeBuilder _entity(SkinRenderFormat format, IResourceLocation texture) {
        return SkinRenderType._builder(format).texture(texture).polygonOffset(0.0f, 30.0f).overlay().lightmap().sortOnUpload().crumbling().outline();
    }

    private static IRenderTypeBuilder _entityHighlight(IResourceLocation texture) {
        return SkinRenderType._builder(SkinRenderFormat.ENTITY_ALPHA).texture(texture).overlay().lightmap();
    }

    private static IRenderTypeBuilder _blockFace(SkinRenderFormat format) {
        return SkinRenderType._builder(format).outline();
    }

    private static IRenderTypeBuilder _customFace(SkinRenderFormat format) {
        return SkinRenderType._builder(format).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).target(IRenderTypeBuilder.Target.TRANSLUCENT).outline();
    }

    private static IRenderTypeBuilder _texture(IResourceLocation texture) {
        return SkinRenderType._builder(SkinRenderFormat.IMAGE).texture(texture).transparency(IRenderTypeBuilder.Transparency.TRANSLUCENT).target(IRenderTypeBuilder.Target.TRANSLUCENT);
    }

    private static IRenderTypeBuilder _texture2(IResourceLocation texture) {
        return SkinRenderType._builder(SkinRenderFormat.BLOCK_CUTOUT).texture(texture).overlay().lightmap();
    }

    private static IRenderTypeBuilder _block(IResourceLocation texture) {
        return SkinRenderType._builder(SkinRenderFormat.BLOCK).texture(texture).overlay().lightmap();
    }

    private static IRenderTypeBuilder _line(float lineWidth) {
        return SkinRenderType._builder(SkinRenderFormat.LINE).lineWidth(lineWidth).polygonOffset(0.0f, 10.0f);
    }

    private static IRenderTypeBuilder _builder(SkinRenderFormat format) {
        return AbstractRenderType.builder(format).property(FORMAT, format);
    }
}

