/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinOverriddenManager {
    private static final List<EquipmentSlot> ARMOUR_EQUIPMENT_SLOTS = Collections.immutableList(builder -> {
        builder.add((Object)EquipmentSlot.HEAD);
        builder.add((Object)EquipmentSlot.CHEST);
        builder.add((Object)EquipmentSlot.LEGS);
        builder.add((Object)EquipmentSlot.FEET);
    });
    private static final List<ISkinProperty<Boolean>> OVERRIDDEN_PROPERTIES = Collections.immutableList(builder -> {
        builder.add(SkinProperty.OVERRIDE_MODEL_HEAD);
        builder.add(SkinProperty.OVERRIDE_MODEL_CHEST);
        builder.add(SkinProperty.OVERRIDE_MODEL_LEFT_ARM);
        builder.add(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM);
        builder.add(SkinProperty.OVERRIDE_MODEL_LEFT_LEG);
        builder.add(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG);
        builder.add(SkinProperty.OVERRIDE_MODEL_LEFT_FRONT_LEG);
        builder.add(SkinProperty.OVERRIDE_MODEL_RIGHT_FRONT_LEG);
        builder.add(SkinProperty.OVERRIDE_MODEL_LEFT_HIND_LEG);
        builder.add(SkinProperty.OVERRIDE_MODEL_RIGHT_HIND_LEG);
        builder.add(SkinProperty.OVERRIDE_MODEL_TAIL);
        builder.add(SkinProperty.OVERRIDE_OVERLAY_HAT);
        builder.add(SkinProperty.OVERRIDE_OVERLAY_CLOAK);
        builder.add(SkinProperty.OVERRIDE_OVERLAY_JACKET);
        builder.add(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE);
        builder.add(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE);
        builder.add(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS);
        builder.add(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS);
        builder.add(SkinProperty.OVERRIDE_EQUIPMENT_HELMET);
        builder.add(SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE);
        builder.add(SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS);
        builder.add(SkinProperty.OVERRIDE_EQUIPMENT_BOOTS);
    });
    private static final Map<ISkinProperty<Boolean>, EquipmentSlot> OVERRIDDEN_EQUIPMENT_TO_SLOT = Collections.immutableMap(builder -> {
        builder.put(SkinProperty.OVERRIDE_EQUIPMENT_HELMET, (Object)EquipmentSlot.HEAD);
        builder.put(SkinProperty.OVERRIDE_EQUIPMENT_CHESTPLATE, (Object)EquipmentSlot.CHEST);
        builder.put(SkinProperty.OVERRIDE_EQUIPMENT_LEGGINGS, (Object)EquipmentSlot.LEGS);
        builder.put(SkinProperty.OVERRIDE_EQUIPMENT_BOOTS, (Object)EquipmentSlot.FEET);
    });
    private static final Map<ISkinProperty<Boolean>, Collection<ISkinProperty<Boolean>>> OVERRIDDEN_MODEL_TO_OVERLAY = Collections.immutableMap(builder -> {
        builder.put(SkinProperty.OVERRIDE_MODEL_HEAD, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_HAT));
        builder.put(SkinProperty.OVERRIDE_MODEL_CHEST, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_JACKET, SkinProperty.OVERRIDE_OVERLAY_CLOAK));
        builder.put(SkinProperty.OVERRIDE_MODEL_LEFT_ARM, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_LEFT_SLEEVE));
        builder.put(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_RIGHT_SLEEVE));
        builder.put(SkinProperty.OVERRIDE_MODEL_LEFT_LEG, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_LEFT_PANTS));
        builder.put(SkinProperty.OVERRIDE_MODEL_RIGHT_LEG, Collections.newList(SkinProperty.OVERRIDE_OVERLAY_RIGHT_PANTS));
    });
    private final HashSet<ISkinProperty<Boolean>> disabledProperties = new HashSet();
    private final HashSet<ISkinProperty<Boolean>> disabledModelByProperties = new HashSet();
    private final HashSet<EquipmentSlot> disabledEquipmentSlots = new HashSet();
    private final HashSet<EquipmentSlot> disabledEquipmentSlotsByProperties = new HashSet();
    private final HashMap<EquipmentSlot, ItemStack> disabledEquipmentItems = new HashMap();

    public void addEquipment(EquipmentSlot slotType) {
        this.disabledEquipmentSlots.add(slotType);
    }

    public void removeEquipment(EquipmentSlot slotType) {
        this.disabledEquipmentSlots.remove(slotType);
    }

    public void addProperty(ISkinProperty<Boolean> property) {
        Collection<ISkinProperty<Boolean>> overlayProperties;
        this.disabledProperties.add(property);
        EquipmentSlot equipmentSlot = OVERRIDDEN_EQUIPMENT_TO_SLOT.get(property);
        if (equipmentSlot != null) {
            this.disabledEquipmentSlotsByProperties.add(equipmentSlot);
        }
        if ((overlayProperties = OVERRIDDEN_MODEL_TO_OVERLAY.get(property)) != null) {
            this.disabledModelByProperties.add(property);
            this.disabledProperties.addAll(overlayProperties);
        }
    }

    public void merge(ISkinProperties properties) {
        for (ISkinProperty<Boolean> property : OVERRIDDEN_PROPERTIES) {
            if (!properties.get(property).booleanValue()) continue;
            this.addProperty(property);
        }
    }

    public boolean contains(ISkinProperty<Boolean> property) {
        return this.disabledProperties.contains(property);
    }

    public boolean overrideEquipment(EquipmentSlot slotType) {
        return this.disabledEquipmentSlots.contains(slotType) || this.disabledEquipmentSlotsByProperties.contains(slotType);
    }

    public boolean overrideAnyModel() {
        return !this.disabledModelByProperties.isEmpty();
    }

    public boolean overrideHandModel(OpenItemDisplayContext transformType) {
        if (transformType.isLeftHand()) {
            return this.contains(SkinProperty.OVERRIDE_MODEL_LEFT_ARM);
        }
        if (transformType.isRightHand()) {
            return this.contains(SkinProperty.OVERRIDE_MODEL_RIGHT_ARM);
        }
        return false;
    }

    public void clear() {
        this.disabledProperties.clear();
        this.disabledModelByProperties.clear();
        this.disabledEquipmentSlots.clear();
        this.disabledEquipmentSlotsByProperties.clear();
    }

    public void willRender(Entity entity) {
        for (EquipmentSlot slotType : ARMOUR_EQUIPMENT_SLOTS) {
            if (!this.overrideEquipment(slotType) || this.disabledEquipmentItems.containsKey(slotType)) continue;
            ItemStack itemStack = this.setItem(entity, slotType, ItemStack.f_41583_);
            this.disabledEquipmentItems.put(slotType, itemStack);
        }
    }

    public void didRender(Entity entity) {
        for (EquipmentSlot slotType : ARMOUR_EQUIPMENT_SLOTS) {
            if (!this.disabledEquipmentItems.containsKey(slotType)) continue;
            ItemStack itemStack = this.disabledEquipmentItems.remove(slotType);
            this.setItem(entity, slotType, itemStack);
        }
    }

    private ItemStack setItem(Entity entity, EquipmentSlot slotType, ItemStack itemStack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Inventory inventory = player.m_150109_();
            ItemStack itemStack1 = (ItemStack)inventory.f_35975_.get(slotType.m_20749_());
            inventory.f_35975_.set(slotType.m_20749_(), (Object)itemStack);
            return itemStack1;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack itemStack1 = livingEntity.m_6844_(slotType);
            livingEntity.m_8061_(slotType, itemStack);
            return itemStack1;
        }
        return itemStack;
    }
}

