/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlaceholderManager {
    private static final int PLACEHOLDER_ENTITY_ID = -1021;
    public static final Supplier<MannequinEntity> MANNEQUIN = new LazyEntry<MannequinEntity>(level -> {
        MannequinEntity entity = new MannequinEntity((EntityType<? extends MannequinEntity>)((EntityType)((IEntityType)ModEntityTypes.MANNEQUIN.get()).get()), (Level)level);
        entity.setExtraRenderer(false);
        return entity;
    });

    public static boolean isPlaceholder(Entity entity) {
        if (entity != null) {
            return entity.m_19879_() == -1021;
        }
        return false;
    }

    private static class LazyEntry<T extends Entity>
    implements Supplier<T> {
        private T entity;
        private final Function<Level, T> provider;

        private LazyEntry(Function<Level, T> provider) {
            this.provider = provider;
        }

        @Override
        public T get() {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (this.entity == null) {
                this.entity = (Entity)this.provider.apply((Level)level);
                this.entity.m_20234_(-1021);
            }
            if (PropertyProvider.getLevel(this.entity) != level) {
                this.entity.m_284535_((Level)level);
            }
            return this.entity;
        }
    }
}

