/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;

public class ItemTransform {
    public static final ItemTransform NO_TRANSFORM = new ItemTransform(OpenVector3f.ZERO, OpenVector3f.ZERO, OpenVector3f.ONE);
    private final OpenVector3f translation;
    private final OpenVector3f rotation;
    private final OpenVector3f scale;

    public ItemTransform(OpenVector3f translation, OpenVector3f rotation, OpenVector3f scale) {
        this.translation = translation;
        this.rotation = rotation;
        this.scale = scale;
    }

    public static ItemTransform create(OpenTransform3f transform) {
        return new ItemTransform(transform.translate(), transform.rotation(), transform.scale());
    }

    public static ItemTransform create(OpenVector3f translation, OpenVector3f rotation, OpenVector3f scale) {
        translation = ItemTransform.optimize(translation, OpenVector3f.ZERO);
        rotation = ItemTransform.optimize(rotation, OpenVector3f.ZERO);
        scale = ItemTransform.optimize(scale, OpenVector3f.ONE);
        if (translation == OpenVector3f.ZERO && rotation == OpenVector3f.ZERO && scale == OpenVector3f.ONE) {
            return NO_TRANSFORM;
        }
        return new ItemTransform(translation, rotation, scale);
    }

    public void apply(boolean applyLeftHandTransform, IPoseStack poseStack) {
        int i;
        if (this == NO_TRANSFORM) {
            return;
        }
        int n = i = applyLeftHandTransform ? -1 : 1;
        if (this.translation != OpenVector3f.ZERO) {
            poseStack.translate((float)i * this.translation.x(), this.translation.y(), this.translation.z());
        }
        if (this.rotation != OpenVector3f.ZERO) {
            float f = this.rotation.x();
            float g = this.rotation.y();
            float h = this.rotation.z();
            if (applyLeftHandTransform) {
                g = -g;
                h = -h;
            }
            poseStack.rotate(OpenQuaternionf.fromEulerAnglesXYZ(f, g, h, true));
        }
        if (this.scale != OpenVector3f.ONE) {
            poseStack.scale(this.scale.x(), this.scale.y(), this.scale.z());
        }
    }

    public OpenVector3f getTranslation() {
        return this.translation;
    }

    public OpenVector3f getRotation() {
        return this.rotation;
    }

    public OpenVector3f getScale() {
        return this.scale;
    }

    protected static <T> T optimize(T value, T targetValue) {
        if (value.equals(targetValue)) {
            return targetValue;
        }
        return value;
    }
}

