/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.IResourceManager;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.item.ItemProperties.ABI;
import moe.plushie.armourers_workshop.core.client.model.ItemModel;
import moe.plushie.armourers_workshop.core.client.model.ItemOverride;
import moe.plushie.armourers_workshop.core.client.model.ItemProperty;
import moe.plushie.armourers_workshop.core.client.model.ItemTransform;
import moe.plushie.armourers_workshop.core.client.model.SkinItemTransform;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.core.utils.JsonSerializer;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ItemModelManager {
    private static final ItemModelManager INSTANCE = new ItemModelManager();
    private ItemModel missingModel;
    private final Map<SkinType, ItemModel> typedItemModels = new ConcurrentHashMap<SkinType, ItemModel>();
    private final Map<IResourceLocation, ItemModel> namedItemModels = new ConcurrentHashMap<IResourceLocation, ItemModel>();
    private final Map<IResourceLocation, ItemProperty> namedItemProperties = Collections.immutableMap(builder -> {
        builder.put((Object)ModConstants.key("is_skin"), (Object)ItemModelManager.vanilla("armourers_workshop:is_skin"));
        builder.put((Object)ModConstants.key("is_crossbow"), (Object)ItemModelManager.vanilla("armourers_workshop:is_crossbow"));
        builder.put((Object)ModConstants.key("is_blocking"), (Object)ItemModelManager.vanilla("minecraft:blocking"));
        builder.put((Object)ModConstants.key("is_throwing"), (Object)ItemModelManager.vanilla("minecraft:throwing"));
    });

    public static ItemModelManager getInstance() {
        return INSTANCE;
    }

    public static void init() {
        new SimpleLoader(INSTANCE).load();
    }

    public ItemModel getModel(SkinType skinType) {
        return this.typedItemModels.computeIfAbsent(skinType, it -> {
            OpenResourceLocation id = ModConstants.key("skin/" + skinType.getRegistryName().getPath());
            return this.namedItemModels.getOrDefault(id, this.missingModel);
        });
    }

    @Nullable
    public ItemProperty getProperty(IResourceLocation id) {
        return this.namedItemProperties.get(id);
    }

    private static ItemProperty vanilla(String id) {
        final OpenResourceLocation registryName = OpenResourceLocation.parse(id);
        final ResourceLocation location = registryName.toLocation();
        return new ItemProperty(){

            @Override
            public float apply(ItemStack itemStack, @Nullable Entity entity, @Nullable Level level, int flags) {
                ItemPropertyFunction func = ABI.getProperty(ItemProperties.class, itemStack, location);
                if (func != null) {
                    return func.m_141951_(itemStack, (ClientLevel)level, (LivingEntity)entity, flags);
                }
                return Float.NEGATIVE_INFINITY;
            }

            public String toString() {
                return registryName.toString();
            }
        };
    }

    private static class SimpleLoader {
        private final ItemModelManager modelManager;
        private final IResourceManager resourceManager;
        private final Map<IResourceLocation, SimpleBuilder> builders = new LinkedHashMap<IResourceLocation, SimpleBuilder>();
        private final Map<IResourceLocation, ItemModel> models = new LinkedHashMap<IResourceLocation, ItemModel>();

        public SimpleLoader(ItemModelManager modelManager) {
            this.modelManager = modelManager;
            this.resourceManager = EnvironmentManager.getResourceManager();
        }

        public void load() {
            this.resourceManager.readResources(ModConstants.key("models/skin"), s -> s.endsWith(".json"), (location, resource) -> {
                IODataObject object = JsonSerializer.readFromResource(resource);
                if (object == null) {
                    return;
                }
                String path = FileUtils.getRegistryName(location.getPath(), "models/");
                IResourceLocation location1 = location.withPath(FileUtils.removeExtension(path));
                SimpleBuilder builder = this.builders.computeIfAbsent(location1, SimpleBuilder::new);
                object.get("parent").ifPresent(it -> {
                    OpenResourceLocation key = OpenResourceLocation.parse(it.stringValue());
                    builder.parent = this.builders.computeIfAbsent(key, SimpleBuilder::new);
                });
                object.get("display").entrySet().forEach(entry -> {
                    String name = (String)entry.getKey();
                    IODataObject value = (IODataObject)entry.getValue();
                    OpenVector3f translation = this.parseVector3f(value.get("translation"), OpenVector3f.ZERO);
                    OpenVector3f rotation = this.parseVector3f(value.get("rotation"), OpenVector3f.ZERO);
                    OpenVector3f scale = this.parseVector3f(value.get("scale"), OpenVector3f.ONE);
                    OpenVector3f rightTranslation = this.parseVector3f(value.get("post_translation"), OpenVector3f.ZERO);
                    OpenVector3f rightRotation = this.parseVector3f(value.get("post_rotation"), OpenVector3f.ZERO);
                    OpenVector3f rightScale = this.parseVector3f(value.get("post_scale"), OpenVector3f.ONE);
                    builder.addTransform(name, SkinItemTransform.create(translation, rotation, scale, rightTranslation, rightRotation, rightScale));
                });
                object.get("overrides").allValues().forEach(it -> {
                    String model = it.get("model").stringValue();
                    ArrayList<Pair<IResourceLocation, Number>> predicate = new ArrayList<Pair<IResourceLocation, Number>>();
                    it.get("predicate").entrySet().forEach(entry -> {
                        OpenResourceLocation key = ModConstants.key((String)entry.getKey());
                        Number value = ((IODataObject)entry.getValue()).numberValue();
                        predicate.add(Pair.of((Object)key, (Object)value));
                    });
                    builder.addOverride(model, predicate);
                });
            });
            IdentityHashMap<ItemOverride, IResourceLocation> references = new IdentityHashMap<ItemOverride, IResourceLocation>();
            this.builders.forEach((name, builder) -> {
                ItemModel itemModel = builder.build(references);
                this.models.put((IResourceLocation)name, itemModel);
            });
            references.forEach((override, reference) -> override.setModel(this.models.get(reference)));
            ItemModel missingModel = this.models.get(ModConstants.key("skin/unknown"));
            if (missingModel == null) {
                throw new RuntimeException("Can't find missing model, some think wrong!");
            }
            this.modelManager.namedItemModels.putAll(this.models);
            this.modelManager.missingModel = missingModel;
        }

        private OpenVector3f parseVector3f(IODataObject value, OpenVector3f defaultValue) {
            if (value.isNull()) {
                return defaultValue;
            }
            if (value.size() != 3) {
                throw new RuntimeException("Expected 3 double values, found: " + String.valueOf(value.allValues()));
            }
            float x = value.at(0).floatValue();
            float y = value.at(1).floatValue();
            float z = value.at(2).floatValue();
            return new OpenVector3f(x, y, z);
        }
    }

    private static class SimpleBuilder {
        private SimpleBuilder parent;
        private final IResourceLocation name;
        private final Map<IResourceLocation, List<Pair<IResourceLocation, Number>>> overrides = new LinkedHashMap<IResourceLocation, List<Pair<IResourceLocation, Number>>>();
        private final Map<OpenItemDisplayContext, ItemTransform> transforms = new LinkedHashMap<OpenItemDisplayContext, ItemTransform>();

        public SimpleBuilder(IResourceLocation name) {
            this.name = name;
        }

        public void addOverride(String name, List<Pair<IResourceLocation, Number>> predicate) {
            this.overrides.put(OpenResourceLocation.parse(name), predicate);
        }

        public void addTransform(String name, ItemTransform transform) {
            this.transforms.put(OpenItemDisplayContext.byName(name), transform);
        }

        public ItemModel build(Map<ItemOverride, IResourceLocation> references) {
            ArrayList<ItemOverride> itemOverrides = new ArrayList<ItemOverride>();
            for (Map.Entry<IResourceLocation, List<Pair<IResourceLocation, Number>>> override : this.overrides.entrySet()) {
                List<Pair<IResourceLocation, Number>> it = override.getValue();
                ItemProperty[] properties = new ItemProperty[it.size()];
                float[] values = new float[it.size()];
                for (int i = 0; i < properties.length; ++i) {
                    properties[i] = ItemModelManager.getInstance().getProperty((IResourceLocation)it.get(i).getKey());
                    values[i] = ((Number)it.get(i).getValue()).floatValue();
                }
                ItemOverride itemOverride = new ItemOverride(properties, values);
                itemOverrides.add(itemOverride);
                references.put(itemOverride, override.getKey());
            }
            EnumMap<OpenItemDisplayContext, ItemTransform> itemTransforms = new EnumMap<OpenItemDisplayContext, ItemTransform>(OpenItemDisplayContext.class);
            for (OpenItemDisplayContext displayContext : OpenItemDisplayContext.values()) {
                itemTransforms.put(displayContext, this.resolveTransformValue(displayContext, ItemTransform.NO_TRANSFORM));
            }
            return new ItemModel(this.name, itemOverrides, itemTransforms);
        }

        private ItemTransform resolveTransformValue(OpenItemDisplayContext transformType, ItemTransform defaultValue) {
            ItemTransform transform = this.transforms.get((Object)transformType);
            if (transform != null) {
                return transform;
            }
            if (this.parent != null) {
                return this.parent.resolveTransformValue(transformType, defaultValue);
            }
            return defaultValue;
        }
    }
}

