/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.client.model.ItemOverride;
import moe.plushie.armourers_workshop.core.client.model.ItemProperty;
import moe.plushie.armourers_workshop.core.client.model.ItemTransform;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemModel {
    private final IResourceLocation name;
    private final Map<OpenItemDisplayContext, ItemTransform> transforms;
    private final ItemProperty[] properties;
    private final List<ItemPropertyMatcher> matchers = new ArrayList<ItemPropertyMatcher>();

    public ItemModel(IResourceLocation name, List<ItemOverride> overrides, Map<OpenItemDisplayContext, ItemTransform> transforms) {
        this.name = name;
        this.transforms = transforms;
        ArrayList<ItemProperty> indexedProperties = new ArrayList<ItemProperty>();
        for (ItemOverride override : overrides) {
            ArrayList<Predicate<float[]>> childTester = new ArrayList<Predicate<float[]>>();
            ItemProperty[] childProperties = override.getProperties();
            float[] childValues = override.getValues();
            for (int i = 0; i < childProperties.length; ++i) {
                ItemProperty childProperty = childProperties[i];
                float childValue = childValues[i];
                int idx = indexedProperties.indexOf(childProperty);
                if (idx == -1) {
                    idx = indexedProperties.size();
                    indexedProperties.add(childProperty);
                }
                int index = idx;
                childTester.add(result -> result[index] >= childValue);
            }
            this.matchers.add(new ItemPropertyMatcher(override, childTester));
        }
        this.properties = indexedProperties.toArray(new ItemProperty[0]);
    }

    public ItemModel resolve(ItemStack itemStack, @Nullable Entity entity, @Nullable Level level, int flags) {
        int length = this.properties.length;
        if (length == 0) {
            return this;
        }
        float[] results = new float[length];
        for (int i = 0; i < length; ++i) {
            results[i] = this.properties[i].apply(itemStack, entity, level, flags);
        }
        for (ItemPropertyMatcher matcher : this.matchers) {
            if (!matcher.test(results)) continue;
            ItemModel model = matcher.override.getModel();
            if (model != null) {
                return model;
            }
            return this;
        }
        return this;
    }

    public ItemTransform getTransform(OpenItemDisplayContext transformType) {
        return this.transforms.getOrDefault((Object)transformType, ItemTransform.NO_TRANSFORM);
    }

    public IResourceLocation getName() {
        return this.name;
    }

    private static class ItemPropertyMatcher {
        private final List<Predicate<float[]>> testers;
        private final ItemOverride override;

        public ItemPropertyMatcher(ItemOverride override, List<Predicate<float[]>> tester) {
            this.testers = tester;
            this.override = override;
        }

        public boolean test(float[] results) {
            for (Predicate<float[]> tester : this.testers) {
                if (tester.test(results)) continue;
                return false;
            }
            return true;
        }
    }
}

