/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import moe.plushie.armourers_workshop.core.client.other.EntitySlot;
import moe.plushie.armourers_workshop.core.client.other.SkinItemProperties;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EmbeddedItemModel {
    private SkinItemProperties properties;
    private final LivingEntity entity;
    private final Level level;
    private final int sourceMode;
    private final ItemStack sourceStack;
    private final SkinDescriptor sourceSkin;
    private final EntitySlot sourceSlot;

    private EmbeddedItemModel(@Nullable LivingEntity entity, @Nullable Level level, int sourceMode, EntitySlot sourceSlot, SkinDescriptor sourceSkin, ItemStack sourceStack) {
        this.entity = entity;
        this.level = level;
        this.sourceMode = sourceMode;
        this.sourceStack = sourceStack;
        this.sourceSkin = sourceSkin;
        this.sourceSlot = sourceSlot;
    }

    public static EmbeddedItemModel fromWardrobe(@Nullable LivingEntity entity, @Nullable Level level, EntitySlot slot) {
        return new EmbeddedItemModel(entity, level, 0, slot, slot.getDescriptor(), slot.getItemStack());
    }

    public static EmbeddedItemModel fromComponent(@Nullable LivingEntity entity, @Nullable Level level, SkinDescriptor descriptor, ItemStack itemStack) {
        return new EmbeddedItemModel(entity, level, 1, null, descriptor, itemStack);
    }

    public static EmbeddedItemModel fromSelf(@Nullable LivingEntity entity, @Nullable Level level, SkinDescriptor descriptor, ItemStack itemStack) {
        return new EmbeddedItemModel(entity, level, 2, null, descriptor, itemStack);
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setProperties(SkinItemProperties properties) {
        this.properties = properties;
    }

    public SkinItemProperties getProperties() {
        return this.properties;
    }

    public SkinDescriptor getSourceSkin() {
        return this.sourceSkin;
    }

    public ItemStack getSourceStack() {
        return this.sourceStack;
    }

    public EntitySlot getSourceSlot() {
        return this.sourceSlot;
    }

    public boolean shouldRenderInBox() {
        if (this.sourceMode == 2) {
            return true;
        }
        SkinType skinType = this.sourceSkin.getType();
        if (skinType == SkinTypes.BOAT || skinType == SkinTypes.ITEM_FISHING || skinType == SkinTypes.HORSE) {
            return true;
        }
        if (skinType.isTool()) {
            return false;
        }
        return skinType != SkinTypes.ITEM;
    }
}

