/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerKey;
import moe.plushie.armourers_workshop.compatibility.client.model.AbstractModelPartHolder;
import moe.plushie.armourers_workshop.core.data.DataContainer;

public class CachedModel<P>
implements IModel {
    private final Container<P> container;
    private final DataContainer storage = new DataContainer();

    public CachedModel(Container<P> container) {
        this.container = container;
    }

    @Override
    public IModelBabyPose getBabyPose() {
        return this.container.getBabyPose();
    }

    @Override
    public IModelPart getPart(String name) {
        return this.container.parts.get(name);
    }

    @Override
    public Collection<? extends IModelPart> getAllParts() {
        return this.container.values;
    }

    @Override
    public <T> T getAssociatedObject(IAssociatedContainerKey<T> key) {
        return this.storage.getAssociatedObject(key);
    }

    @Override
    public <T> void setAssociatedObject(IAssociatedContainerKey<T> key, T value) {
        this.storage.setAssociatedObject(key, value);
    }

    @Override
    public Class<?> getType() {
        return this.container.type;
    }

    public static class Container<P> {
        protected IModelBabyPose babyPose;
        protected final Class<?> type;
        protected final Function<P, IModelPart> transformer;
        protected final ArrayList<IModelPart> values = new ArrayList();
        protected final HashMap<String, IModelPart> parts = new HashMap();

        public Container(Class<?> type, Function<P, IModelPart> transformer) {
            this.type = type;
            this.transformer = transformer;
        }

        public void put(String name, P part) {
            IModelPart holder = this.transformer.apply(part);
            this.parts.put(name, holder);
            this.values.add(holder);
            if (holder instanceof AbstractModelPartHolder) {
                AbstractModelPartHolder holder1 = (AbstractModelPartHolder)holder;
                holder1.setName(name);
            }
        }

        public void unnamed(Iterable<P> parts) {
            for (P part : parts) {
                this.values.add(this.transformer.apply(part));
            }
        }

        public IModelBabyPose getBabyPose() {
            return this.babyPose;
        }
    }
}

