/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.SoundManagerImpl;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import java.util.HashMap;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.init.ModTextures;

public class ScrollIndicator
extends UIControl {
    private final UIButton topButton = new UIButton(CGRect.ZERO);
    private final UIButton middleButton = new DragButton(CGRect.ZERO);
    private final UIButton bottomButton = new UIButton(CGRect.ZERO);
    float value = 0.0f;
    float stepValue = 0.1f;

    public ScrollIndicator(CGRect frame) {
        super(frame);
        this.setup();
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        SoundManagerImpl.click();
        this.middleButton.setSelected(true);
        this.updateValue(this.valueAtPoint(event.locationInView(this)));
    }

    @Override
    public void mouseUp(UIEvent event) {
        super.mouseUp(event);
        this.middleButton.setSelected(false);
    }

    @Override
    public void mouseDragged(UIEvent event) {
        super.mouseDragged(event);
        this.updateValue(this.valueAtPoint(event.locationInView(this)));
    }

    private void setup() {
        CGRect rect = this.bounds();
        int size = 10;
        this.topButton.setFrame(new CGRect(0.0f, 0.0f, size, size));
        this.topButton.setAutoresizingMask(34);
        this.topButton.setBackgroundImage(this.makeImage(20, 0), 7);
        this.topButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ScrollIndicator::upAction);
        this.topButton.setCanBecomeFocused(false);
        this.addSubview(this.topButton);
        this.bottomButton.setFrame(new CGRect(0.0f, rect.maxY() - (float)size, size, size));
        this.bottomButton.setAutoresizingMask(10);
        this.bottomButton.setBackgroundImage(this.makeImage(30, 0), 7);
        this.bottomButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, ScrollIndicator::downAction);
        this.bottomButton.setCanBecomeFocused(false);
        this.addSubview(this.bottomButton);
        UIImageView bg1 = new UIImageView(new CGRect(0.0f, this.topButton.frame().maxY(), size, size));
        UIImageView bg2 = new UIImageView(new CGRect(0.0f, this.bottomButton.frame().minY() - (float)size, size, size));
        UIImageView bg3 = new UIImageView(new CGRect(0.0f, bg1.frame().maxY(), size, bg2.frame().minY() - bg1.frame().maxY()));
        bg1.setImage(this.makeImage(20, 20));
        bg2.setImage(this.makeImage(30, 20));
        bg3.setImage(UIImage.of(ModTextures.SCROLLBAR).uv(246.0f, 0.0f).resizable(10.0f, 246.0f).build());
        bg1.setAutoresizingMask(34);
        bg2.setAutoresizingMask(10);
        bg3.setAutoresizingMask(18);
        this.addSubview(bg1);
        this.addSubview(bg2);
        this.addSubview(bg3);
        this.middleButton.setFrame(new CGRect(0.0f, size, size, size));
        this.middleButton.setBackgroundImage(this.makeImage(40, 0), 7);
        this.middleButton.setCanBecomeFocused(false);
        this.addSubview(this.middleButton);
    }

    private UIImage makeImage(int u, int v) {
        HashMap<Integer, CGPoint> offsets = new HashMap<Integer, CGPoint>();
        offsets.put(0, new CGPoint(0.0f, 0.0f));
        offsets.put(1, new CGPoint(0.0f, 1.0f));
        offsets.put(2, new CGPoint(0.0f, 1.0f));
        return UIImage.of(ModTextures.SCROLLBAR).uv(u, v).fixed(10.0f, 10.0f).unzip(offsets::get).build();
    }

    private void updateOffsetIfNeeded() {
        CGRect frame = this.middleButton.frame();
        float minY = this.topButton.frame().maxY();
        float maxY = this.bottomButton.frame().minY();
        float y = (maxY - minY - frame.height) * this.value;
        this.middleButton.setFrame(new CGRect(frame.x, minY + y, frame.width, frame.height));
    }

    private void updateValue(float value) {
        this.setValue(value);
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
    }

    private float valueAtPoint(CGPoint point) {
        float minY = this.topButton.frame().maxY();
        float maxY = this.bottomButton.frame().minY();
        float y = point.y;
        if (y < minY) {
            return 0.0f;
        }
        if (y > maxY) {
            return 1.0f;
        }
        return (y - minY) / (maxY - minY);
    }

    private void upAction(UIControl sender) {
        this.updateValue(this.value - this.stepValue);
    }

    private void downAction(UIControl sender) {
        this.updateValue(this.value + this.stepValue);
    }

    private void dragAction(UIControl sender) {
    }

    public float value() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = OpenMath.clamp(value, 0.0f, 1.0f);
        this.updateOffsetIfNeeded();
    }

    public float stepValue() {
        return this.stepValue;
    }

    public void setStepValue(float stepValue) {
        this.stepValue = stepValue;
    }

    @Override
    protected boolean shouldPassHighlighted() {
        return false;
    }

    private static class DragButton
    extends UIButton {
        public DragButton(CGRect frame) {
            super(frame);
        }

        @Override
        public void mouseDown(UIEvent event) {
            super.mouseDown(event);
            this.setSelected(true);
        }

        @Override
        public void mouseUp(UIEvent event) {
            super.mouseUp(event);
            this.setSelected(false);
        }

        @Override
        public void mouseDragged(UIEvent event) {
            super.mouseDragged(event);
            this.nextResponder().mouseDragged(event);
        }
    }
}

