/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIView;
import moe.plushie.armourers_workshop.core.client.texture.TextureAnimationController;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTexturePos;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.init.ModTextures;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaintColorView
extends UIView {
    private UIColor color = UIColor.WHITE;
    private SkinPaintType paintType = SkinPaintTypes.NORMAL;

    public PaintColorView(CGRect frame) {
        super(frame);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        SkinTexturePos texture = this.paintType.getTexturePos();
        OpenMatrix4f textureMatrix = TextureAnimationController.DEFAULT.getTextureMatrix(TickUtils.animationTicks());
        OpenVector3f textureOffset = OpenVector3f.ZERO.transforming(textureMatrix);
        float cu = texture.getU();
        float cv = texture.getV();
        int dv = (int)(cv + textureOffset.y() * 256.0f) % 256;
        if (this.paintType != SkinPaintTypes.RAINBOW) {
            context.setBlendColor(this.color);
        }
        CGRect rect = this.bounds();
        context.drawResizableImage(ModTextures.CUBE, 0.0f, 0.0f, rect.width, rect.height, cu, dv, 1.0f, 1.0f, 256.0f, 256.0f);
        if (this.paintType != SkinPaintTypes.RAINBOW) {
            context.setBlendColor(UIColor.WHITE);
        }
    }

    public SkinPaintColor paintColor() {
        return SkinPaintColor.of(this.color.getRGB(), this.paintType);
    }

    public void setPaintColor(SkinPaintColor color) {
        this.setColor(new UIColor(color.getRGB()));
        this.setPaintType(color.getPaintType());
    }

    public SkinPaintType paintType() {
        return this.paintType;
    }

    public void setPaintType(SkinPaintType paintType) {
        this.paintType = paintType;
    }

    public UIColor color() {
        return this.color;
    }

    public void setColor(UIColor color) {
        this.color = color;
    }
}

