/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIControl;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.VerticalStackView;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;

public class FileProviderSettingDialog
extends ConfirmDialog {
    private final VerticalStackView stackView = new VerticalStackView(CGRect.ZERO);
    private final SkinProperties properties;

    public FileProviderSettingDialog(SkinProperties properties) {
        this.setFrame(new CGRect(0.0f, 0.0f, 200.0f, 120.0f));
        this.setTitle(NSString.localizedString("skin-library.dialog.fileProvider.setting", new Object[0]));
        this.properties = properties.copy();
        this.setup(this.bounds());
    }

    private void setup(CGRect rect) {
        this.stackView.setFrame(new CGRect(rect.insetBy(30.0f, 10.0f, 40.0f, 10.0f)));
        this.stackView.setSpacing(4.0f);
        this.stackView.setAutoresizingMask(34);
        this.addSubview(this.stackView);
        this.addCheckBox(SkinProperty.USE_ADAPT_MODE);
        this.addCheckBox(SkinProperty.USE_ITEM_TRANSFORMS);
        this.cancelButton.removeFromSuperview();
        this.confirmButton.setFrame(new CGRect((rect.width - 100.0f) / 2.0f, rect.height - 30.0f, 100.0f, 20.0f));
        this.confirmButton.setAutoresizingMask(13);
    }

    protected void addCheckBox(SkinProperty<Boolean> property) {
        Boolean oldValue = this.properties.get(property);
        UICheckBox checkBox = new UICheckBox(new CGRect(0.0f, 0.0f, 80.0f, 9.0f));
        checkBox.setTitle(this.getDisplayText(property.getKey(), new Object[0]));
        checkBox.setSelected(oldValue);
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, box) -> {
            boolean value = box.isSelected();
            self.properties.put(property, value);
        });
        this.stackView.addArrangedSubview(checkBox);
    }

    public SkinProperties getProperties() {
        return this.properties;
    }

    protected NSString getDisplayText(String key, Object ... objects) {
        return NSString.localizedString("skin-library.dialog.fileProvider.setting." + key, objects);
    }
}

