/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.wardrobe;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSTextRange;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.client.gui.wardrobe.SkinWardrobeBaseSetting;
import moe.plushie.armourers_workshop.core.client.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.Strings;

@OnlyIn(value=Dist.CLIENT)
public class SkinWardrobeTextureSetting
extends SkinWardrobeBaseSetting
implements UITextFieldDelegate {
    private final SkinWardrobe wardrobe;
    private final HashMap<EntityTextureDescriptor.Source, String> defaultValues = new HashMap();
    private final UIComboBox comboView = new UIComboBox(new CGRect(83.0f, 27.0f, 80.0f, 14.0f));
    private final UITextField textField = new UITextField(new CGRect(83.0f, 70.0f, 165.0f, 18.0f));
    private EntityTextureDescriptor lastDescriptor = EntityTextureDescriptor.EMPTY;
    private EntityTextureDescriptor.Source lastSource = EntityTextureDescriptor.Source.NONE;

    public SkinWardrobeTextureSetting(SkinWardrobe wardrobe) {
        super("wardrobe.man_texture");
        this.wardrobe = wardrobe;
        this.prepareDefaultValue();
        this.setup();
    }

    private void setup() {
        this.setupTextField();
        UIButton button = new UIButton(new CGRect(83.0f, 90.0f, 100.0f, 20.0f));
        button.setTitle(this.getDisplayText("set", new Object[0]), 7);
        button.setTitleColor(UIColor.WHITE, 7);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, SkinWardrobeTextureSetting::submit);
        this.addSubview(button);
        this.setupComboView();
    }

    private void setupComboView() {
        int selectedIndex = 0;
        if (this.lastSource != EntityTextureDescriptor.Source.NONE) {
            selectedIndex = this.lastSource.ordinal() - 1;
        }
        ArrayList<UIComboItem> items = new ArrayList<UIComboItem>();
        items.add(new UIComboItem(this.getDisplayText("dropdown.user", new Object[0])));
        items.add(new UIComboItem(this.getDisplayText("dropdown.url", new Object[0])));
        this.comboView.setSelectedIndex(selectedIndex);
        this.comboView.reloadData(items);
        this.comboView.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, e) -> {
            int index = self.comboView.selectedIndex();
            self.changeSource(EntityTextureDescriptor.Source.values()[index + 1]);
        });
        this.addSubview(this.comboView);
    }

    public void setupTextField() {
        String defaultValue = this.defaultValues.get((Object)this.lastSource);
        this.textField.setDelegate(this);
        this.textField.setMaxLength(1024);
        if (Strings.isNotBlank((String)defaultValue)) {
            this.textField.setText(defaultValue);
        }
        this.addSubview(this.textField);
    }

    private void prepareDefaultValue() {
        Entity entity = this.wardrobe.getEntity();
        if (!(entity instanceof MannequinEntity)) {
            return;
        }
        MannequinEntity entity2 = (MannequinEntity)entity;
        this.defaultValues.clear();
        this.lastDescriptor = (EntityTextureDescriptor)entity2.m_20088_().m_135370_(MannequinEntity.DATA_TEXTURE);
        this.lastSource = this.lastDescriptor.getSource();
        if (this.lastSource == EntityTextureDescriptor.Source.USER) {
            this.defaultValues.put(this.lastSource, this.lastDescriptor.getName());
        }
        if (this.lastSource == EntityTextureDescriptor.Source.URL) {
            this.defaultValues.put(this.lastSource, this.lastDescriptor.getURL());
        }
    }

    private void submit(Object button) {
        this.textField.resignFirstResponder();
        int index = this.comboView.selectedIndex();
        EntityTextureDescriptor.Source source = EntityTextureDescriptor.Source.values()[index + 1];
        this.applyText(source, this.textField.text());
    }

    private void changeSource(EntityTextureDescriptor.Source newSource) {
        if (this.lastSource == newSource) {
            return;
        }
        this.defaultValues.put(this.lastSource, this.textField.text());
        this.textField.setText(this.defaultValues.getOrDefault((Object)newSource, ""));
        this.textField.resignFirstResponder();
        this.textField.setSelectedTextRange(new NSTextRange(this.textField.beginOfDocument()));
        this.comboView.setSelectedIndex(newSource.ordinal() - 1);
        this.lastSource = newSource;
    }

    private void applyText(EntityTextureDescriptor.Source source, String value) {
        EntityTextureDescriptor descriptor = EntityTextureDescriptor.EMPTY;
        if (Strings.isNotEmpty((CharSequence)value)) {
            if (source == EntityTextureDescriptor.Source.URL) {
                descriptor = EntityTextureDescriptor.fromURL(value);
            }
            if (source == EntityTextureDescriptor.Source.USER) {
                descriptor = EntityTextureDescriptor.fromName(value);
            }
        }
        PlayerTextureLoader.getInstance().loadTextureDescriptor(descriptor, resolvedDescriptor -> {
            EntityTextureDescriptor newValue = resolvedDescriptor.orElse(EntityTextureDescriptor.EMPTY);
            if (this.lastDescriptor.equals(newValue)) {
                return;
            }
            this.lastSource = EntityTextureDescriptor.Source.NONE;
            this.lastDescriptor = newValue;
            NetworkManager.sendToServer(UpdateWardrobePacket.Field.MANNEQUIN_TEXTURE.buildPacket(this.wardrobe, newValue));
            this.defaultValues.put(newValue.getSource(), newValue.getValue());
            this.changeSource(newValue.getSource());
        });
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        this.submit(textField.text());
        return true;
    }
}

