/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIColor;
import moe.plushie.armourers_workshop.core.client.gui.widget.ClientMenuScreen;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.NotificationDialog;
import moe.plushie.armourers_workshop.core.menu.AbstractContainerMenu;
import moe.plushie.armourers_workshop.core.network.ExecuteAlertPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ServerAlertWindow
extends MenuWindow<AbstractContainerMenu> {
    private final ExecuteAlertPacket alertPacket;

    public ServerAlertWindow(ExecuteAlertPacket alertPacket) {
        super(ClientMenuScreen.getEmptyMenu(), ClientMenuScreen.getEmptyInventory(), new NSString(alertPacket.getTitle()));
        this.titleView.removeFromSuperview();
        this.inventoryView.removeFromSuperview();
        this.alertPacket = alertPacket;
    }

    @Override
    public void init() {
        NotificationDialog dialog = new NotificationDialog();
        dialog.setTitle(new NSString(this.alertPacket.getTitle()));
        dialog.setMessage(new NSString(this.alertPacket.getMessage()));
        if (this.alertPacket.getType() == 1) {
            dialog.setMessageColor(new UIColor(0xFF5555));
        }
        dialog.setConfirmText(new NSString(this.alertPacket.getConfirm()));
        dialog.sizeToFit();
        dialog.showInView(this, this::dismiss);
    }

    public void showInScreen() {
        Minecraft minecraft = Minecraft.m_91087_();
        WrappedScreen screen = new WrappedScreen(this, this.alertPacket.getTitle());
        screen.setTarget(minecraft.f_91080_);
        minecraft.f_91080_ = null;
        minecraft.m_91152_((Screen)screen);
    }

    public void dismiss() {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen instanceof WrappedScreen) {
            WrappedScreen screen2 = (WrappedScreen)screen;
            minecraft.m_91152_(screen2.getTarget());
        }
    }

    public static class WrappedScreen
    extends ClientMenuScreen {
        private Screen targetScreen;

        public WrappedScreen(ServerAlertWindow window, Component component) {
            super(window, component);
        }

        @Override
        public void m_6574_(Minecraft minecraft, int i, int j) {
            super.m_6574_(minecraft, i, j);
            if (this.targetScreen != null) {
                this.targetScreen.m_6574_(minecraft, i, j);
            }
        }

        @Override
        public void render(CGGraphicsContext context, int mouseX, int mouseY, float partialTicks) {
            if (this.targetScreen != null) {
                this.renderBackground(context, this.targetScreen, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            }
            context.saveGraphicsState();
            context.translateCTM(0.0f, 0.0f, 500.0f);
            super.render(context, mouseX, mouseY, partialTicks);
            context.restoreGraphicsState();
        }

        public void setTarget(Screen screen) {
            this.targetScreen = screen;
        }

        public Screen getTarget() {
            return this.targetScreen;
        }
    }
}

