/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.FindableSkinManager;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinPreloadManager {
    private static Object lastInventoryVersion = null;

    public static void start() {
        lastInventoryVersion = null;
        FindableSkinManager.getInstance().start();
    }

    public static void stop() {
        FindableSkinManager.getInstance().stop();
    }

    public static void tick(boolean isPaused) {
        Player player;
        if (isPaused) {
            return;
        }
        if (lastInventoryVersion == null && (player = EnvironmentManager.getPlayer()) != null) {
            Inventory inventory = player.m_150109_();
            int inventoryVersion = inventory.m_36072_();
            SkinPreloadManager.preloadInventory(inventory);
            lastInventoryVersion = inventoryVersion;
        }
        SkinPreloadManager.preloadConfig();
    }

    private static void preloadConfig() {
    }

    private static void preloadInventory(Inventory inventory) {
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            SkinDescriptor descriptor = SkinDescriptor.of(inventory.m_8020_(i));
            if (descriptor.isEmpty()) continue;
            ModLog.debug("'{}' => start preload skin", descriptor.getIdentifier());
            SkinBakery.getInstance().loadSkin(descriptor, Tickets.PRELOAD);
        }
    }
}

