/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedGeometryQuads;
import moe.plushie.armourers_workshop.core.client.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTransform;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.OpenRandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedSkinPart {
    private final int id = OpenRandomSource.nextInt(BakedSkinPart.class);
    private final SkinPart part;
    private final BakedGeometryQuads quads;
    private final SkinPartTransform transform;
    private final ColorDescriptor descriptor;
    private final ArrayList<BakedSkinPart> children = new ArrayList();
    private float renderPolygonOffset;
    private boolean shouldRender = true;
    private Function<IJointTransform, IJointTransform> jointTransformModifier;

    public BakedSkinPart(SkinPart part, SkinPartTransform transform, BakedGeometryQuads quads) {
        this.part = part;
        this.quads = quads;
        this.transform = transform;
        this.descriptor = quads.getColorInfo();
        this.renderPolygonOffset = this.getType().getRenderPolygonOffset();
    }

    public void addPart(BakedSkinPart part) {
        this.children.add(part);
    }

    public void removePart(BakedSkinPart part) {
        this.children.remove(part);
    }

    @Nullable
    public Object requirements(SkinPaintScheme scheme) {
        if (this.descriptor.isEmpty() || scheme.isEmpty()) {
            return null;
        }
        boolean needsEntityTexture = false;
        ArrayList<Object> requirements = new ArrayList<Object>();
        for (SkinPaintType paintType : this.descriptor.getPaintTypes()) {
            if (paintType.getDyeType() != null) {
                SkinPaintColor resolvedColor = scheme.getResolvedColor(paintType);
                requirements.add(paintType.getId());
                requirements.add(resolvedColor);
                if (resolvedColor != null) {
                    paintType = resolvedColor.getPaintType();
                }
            }
            if (paintType != SkinPaintTypes.TEXTURE) continue;
            needsEntityTexture = true;
        }
        if (needsEntityTexture && PlayerTextureLoader.getInstance().getTextureModel(scheme.getTexture()) != null) {
            requirements.add(SkinPaintTypes.TEXTURE.getId());
            requirements.add(scheme.getTexture());
        }
        return requirements;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        String name = this.part.getName();
        if (name == null) {
            name = this.part.getType().getName();
        }
        return name;
    }

    public SkinPart getPart() {
        return this.part;
    }

    public SkinPartType getType() {
        return this.part.getType();
    }

    public SkinPartTransform getTransform() {
        return this.transform;
    }

    public ColorDescriptor getColorInfo() {
        return this.quads.getColorInfo();
    }

    public OpenVoxelShape getRenderShape() {
        return this.quads.getShape();
    }

    public int getMarkerTotal() {
        return this.part.getMarkers().size();
    }

    public void setRenderPolygonOffset(float renderPolygonOffset) {
        this.renderPolygonOffset = renderPolygonOffset;
    }

    public float getRenderPolygonOffset() {
        return this.renderPolygonOffset;
    }

    public void setShouldRender(boolean shouldRender) {
        this.shouldRender = shouldRender;
    }

    public boolean isVisible() {
        return this.shouldRender;
    }

    public ArrayList<BakedSkinPart> getChildren() {
        return this.children;
    }

    public SkinProperties getProperties() {
        return this.part.getProperties();
    }

    public void setJointTransformModifier(Function<IJointTransform, IJointTransform> jointTransformModifier) {
        this.jointTransformModifier = jointTransformModifier;
    }

    public Function<IJointTransform, IJointTransform> getJointTransformModifier() {
        return this.jointTransformModifier;
    }

    public BakedGeometryQuads getQuads() {
        return this.quads;
    }
}

