/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.Comparator;
import moe.plushie.armourers_workshop.core.client.animation.AnimationEngine;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderHelper;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.tuple.Pair;

public class BakedSkinAnimationHandler {
    private final ArrayList<Callback> tasks = new ArrayList();
    private final ArrayList<Pair<Integer, Callback>> pending = new ArrayList();

    public BakedSkinAnimationHandler() {
        this.normal((skin, entity, armature, context) -> AnimationEngine.apply(entity, skin, context));
        this.normal((skin, entity, armature, context) -> SkinRenderHelper.apply(entity, skin, armature, context.getItemSource()));
    }

    public void lowest(Callback handler) {
        this.pending.add((Pair<Integer, Callback>)Pair.of((Object)-100, (Object)handler));
        this.rebuild();
    }

    public void low(Callback handler) {
        this.pending.add((Pair<Integer, Callback>)Pair.of((Object)-10, (Object)handler));
        this.rebuild();
    }

    public void normal(Callback handler) {
        this.pending.add((Pair<Integer, Callback>)Pair.of((Object)0, (Object)handler));
        this.rebuild();
    }

    public void high(Callback handler) {
        this.pending.add((Pair<Integer, Callback>)Pair.of((Object)10, (Object)handler));
        this.rebuild();
    }

    public void highest(Callback handler) {
        this.pending.add((Pair<Integer, Callback>)Pair.of((Object)100, (Object)handler));
        this.rebuild();
    }

    public void apply(BakedSkin skin, Entity entity, BakedArmature armature, SkinRenderContext context) {
        for (Callback task : this.tasks) {
            task.apply(skin, entity, armature, context);
        }
    }

    private void rebuild() {
        this.tasks.clear();
        this.pending.stream().sorted(Comparator.comparingInt(Pair::getLeft)).forEachOrdered(it -> this.tasks.add((Callback)it.getRight()));
    }

    public static interface Callback {
        public void apply(BakedSkin var1, Entity var2, BakedArmature var3, SkinRenderContext var4);
    }
}

