/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import com.google.common.collect.Range;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanUse;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedTransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimationController;
import moe.plushie.armourers_workshop.core.client.bake.BakedAdapterJointTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedAttachmentPartTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedBackpackPartTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinAnimationHandler;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPartCombiner;
import moe.plushie.armourers_workshop.core.client.model.ItemTransform;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.core.data.cache.PrimaryKey;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.part.wings.WingPartTransform;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import moe.plushie.armourers_workshop.core.utils.OpenRandomSource;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BakedSkin {
    private final int id = OpenRandomSource.nextInt(BakedSkin.class);
    private final String identifier;
    private final Skin skin;
    private final SkinType skinType;
    private final HashMap<Object, OpenRectangle3f> cachedBounds = new HashMap();
    private final HashMap<OpenVector3i, OpenRectangle3f> cachedBlockBounds = new HashMap();
    private final Range<Integer> useTickRange;
    private final List<BakedSkinPart> skinParts;
    private final List<AnimationController> animationControllers;
    private final ColorDescriptor colorDescriptor;
    private final SkinUsedCounter usedCounter;
    private final BakedItemTransform itemTransform;
    private final SkinPaintScheme paintScheme;
    private final Int2ObjectMap<SkinPaintScheme> resolvedColorSchemes = new Int2ObjectOpenHashMap();
    private final BakedSkinAnimationHandler animationHandler = new BakedSkinAnimationHandler();

    public BakedSkin(String identifier, SkinType skinType, ArrayList<BakedSkinPart> bakedParts, Skin skin, SkinPaintScheme paintScheme, ColorDescriptor colorDescriptor, SkinUsedCounter usedCounter) {
        this.identifier = identifier;
        this.skin = skin;
        this.skinType = skinType;
        this.animationControllers = this.resolveAnimationControllers(bakedParts, skin.getAnimations(), skin.getProperties());
        this.skinParts = BakedSkinPartCombiner.apply(bakedParts);
        this.paintScheme = paintScheme;
        this.colorDescriptor = colorDescriptor;
        this.usedCounter = usedCounter;
        this.useTickRange = this.getUseTickRange(this.skinParts);
        this.itemTransform = this.resolvedItemTransform(this.skinParts, skin);
        this.loadBlockBounds(this.skinParts);
        this.loadPartTransforms(this.skinParts);
    }

    public void setupAnim(Entity entity, BakedArmature bakedArmature, SkinRenderContext context) {
        this.animationHandler.apply(this, entity, bakedArmature, context);
    }

    public SkinPaintScheme resolve(Entity entity, SkinPaintScheme scheme) {
        if (this.colorDescriptor.isEmpty()) {
            return SkinPaintScheme.EMPTY;
        }
        SkinPaintScheme resolvedColorScheme = (SkinPaintScheme)this.resolvedColorSchemes.computeIfAbsent(entity.m_19879_(), k -> this.paintScheme.copy());
        if (PlaceholderManager.isPlaceholder(entity)) {
            OpenResourceLocation resolvedTexture = PlayerTextureLoader.getInstance().getTextureLocation(entity);
            if (!Objects.equals(resolvedColorScheme.getTexture(), resolvedTexture)) {
                resolvedColorScheme.setTexture(resolvedTexture);
            }
        }
        resolvedColorScheme.setReference(scheme);
        return resolvedColorScheme;
    }

    public int getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public SkinType getType() {
        return this.skinType;
    }

    public List<BakedSkinPart> getParts() {
        return this.skinParts;
    }

    public SkinProperties getProperties() {
        return this.skin.getProperties();
    }

    public List<AnimationController> getAnimationControllers() {
        return this.animationControllers;
    }

    public SkinPaintScheme getPaintScheme() {
        return this.paintScheme;
    }

    public ColorDescriptor getColorDescriptor() {
        return this.colorDescriptor;
    }

    public BakedItemTransform getItemTransform() {
        return this.itemTransform;
    }

    public Range<Integer> getUseTickRange() {
        return this.useTickRange;
    }

    public SkinUsedCounter getUsedCounter() {
        return this.usedCounter;
    }

    public Map<OpenVector3i, OpenRectangle3f> getBlockBounds() {
        return this.cachedBlockBounds;
    }

    public OpenRectangle3f getRenderBounds() {
        return this.getRenderBounds(ItemTransform.NO_TRANSFORM, OpenItemDisplayContext.NONE);
    }

    public OpenRectangle3f getRenderBounds(ItemTransform itemTransform, OpenItemDisplayContext displayContext) {
        OpenVector3f rotation = itemTransform.getRotation();
        PrimaryKey key = PrimaryKey.of(rotation, (Object)displayContext);
        OpenRectangle3f bounds = this.cachedBounds.get(key);
        if (bounds != null) {
            return bounds;
        }
        MannequinEntity entity = PlaceholderManager.MANNEQUIN.get();
        OpenMatrix4f matrix = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
        OpenVoxelShape shape = this.getRenderShape((Entity)entity, BakedArmature.defaultBy(this.skinType), displayContext);
        if (!rotation.equals(OpenVector3f.ZERO)) {
            matrix.rotate(new OpenQuaternionf(rotation.x(), rotation.y(), rotation.z(), true));
            shape.mul(matrix);
        }
        bounds = shape.bounds().copy();
        if (!rotation.equals(OpenVector3f.ZERO)) {
            OpenVector4f center = new OpenVector4f(bounds.center());
            matrix.invert();
            center.transform(matrix);
            bounds.setX(center.x() - bounds.width() / 2.0f);
            bounds.setY(center.y() - bounds.height() / 2.0f);
            bounds.setZ(center.z() - bounds.depth() / 2.0f);
        }
        this.cachedBounds.put(key.copy(), bounds);
        return bounds;
    }

    private OpenVoxelShape getRenderShape(Entity entity, BakedArmature armature, OpenItemDisplayContext displayContext) {
        if (armature == null) {
            return OpenVoxelShape.empty();
        }
        SkinRenderContext context = new SkinRenderContext();
        context.setItemSource(SkinItemSource.EMPTY);
        context.setDisplayContext(displayContext);
        context.setAnimationTicks(0.0);
        this.setupAnim(entity, armature, context);
        return SkinRenderer.getShape(entity, armature, this, context.pose());
    }

    private void loadPartTransforms(List<BakedSkinPart> skinParts) {
        Collections.eachTree(skinParts, BakedSkinPart::getChildren, part -> {
            if (part.getProperties().get(SkinProperty.USE_ADAPT_MODE).booleanValue()) {
                BakedAdapterJointTransform adapterTransform = new BakedAdapterJointTransform((BakedSkinPart)part);
                part.setJointTransformModifier(it -> adapterTransform);
                this.animationHandler.normal((skin, entity, armature, context) -> adapterTransform.setup(entity, armature, context));
            }
        });
        Collections.eachTree(skinParts, BakedSkinPart::getChildren, part -> part.getTransform().getChildren().forEach(transform -> {
            if (transform instanceof AnimatedTransform) {
                AnimatedTransform animatedTransform = (AnimatedTransform)transform;
                this.animationHandler.lowest((skin, entity, armature, context) -> animatedTransform.reset());
            }
        }));
        skinParts.forEach(it -> it.getTransform().getChildren().forEach(transform -> {
            if (transform instanceof WingPartTransform) {
                WingPartTransform wingTransform = (WingPartTransform)transform;
                this.animationHandler.normal((skin, entity, armature, context) -> wingTransform.setup(entity, context.getAnimationTicks()));
            }
        }));
        BakedAttachmentPartTransform.create(skinParts).forEach(attachmentTransform -> this.animationHandler.normal((skin, entity, armature, context) -> attachmentTransform.setup(entity, armature, context)));
        Collections.filter(skinParts, it -> it.getType() == SkinPartTypes.ITEM_BACKPACK).forEach(it -> {
            BakedBackpackPartTransform backpackTransform = new BakedBackpackPartTransform();
            it.getTransform().insertChild(backpackTransform, 0);
            this.animationHandler.highest((skin, entity, armature, context) -> backpackTransform.setup(entity, context.getRenderData()));
        });
    }

    private void loadBlockBounds(List<BakedSkinPart> skinParts) {
        if (this.skinType != SkinTypes.BLOCK) {
            return;
        }
        for (BakedSkinPart skinPart : skinParts) {
            Map<OpenVector3i, OpenRectangle3f> bounds = skinPart.getPart().getBlockBounds();
            if (bounds == null) continue;
            this.cachedBlockBounds.putAll(bounds);
        }
    }

    private Range<Integer> getUseTickRange(List<BakedSkinPart> skinParts) {
        int count = 0;
        int maxUseTick = Integer.MIN_VALUE;
        int minUseTick = Integer.MAX_VALUE;
        for (BakedSkinPart bakedPart : skinParts) {
            SkinPartType skinPartType = bakedPart.getType();
            if (!(skinPartType instanceof ICanUse)) continue;
            ICanUse partType = (ICanUse)((Object)skinPartType);
            Range<Integer> range = partType.getUseRange();
            maxUseTick = Math.max(maxUseTick, (Integer)range.upperEndpoint());
            minUseTick = Math.min(minUseTick, (Integer)range.lowerEndpoint());
            ++count;
        }
        if (count == 0) {
            return Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
        }
        return Range.closed((Comparable)Integer.valueOf(minUseTick), (Comparable)Integer.valueOf(maxUseTick));
    }

    private BakedItemTransform resolvedItemTransform(List<BakedSkinPart> skinParts, Skin skin) {
        OpenItemTransforms itemTransforms = skin.getItemTransforms();
        return BakedItemTransform.create(skinParts, itemTransforms, skin.getType());
    }

    private List<AnimationController> resolveAnimationControllers(List<BakedSkinPart> skinParts, Collection<SkinAnimation> animations, SkinProperties properties) {
        ArrayList<AnimationController> animationControllers = new ArrayList<AnimationController>();
        if (animations.isEmpty()) {
            return animationControllers;
        }
        HashMap namedParts = new HashMap();
        Collections.eachTree(skinParts, BakedSkinPart::getChildren, part -> {
            String partName = part.getName();
            if (partName.isEmpty()) {
                partName = part.getType().getName();
            }
            namedParts.put(partName, part.getTransform());
        });
        animations.forEach(animation -> {
            AnimationController controller = new AnimationController((SkinAnimation)animation, namedParts);
            animationControllers.add(controller);
        });
        animationControllers.removeIf(AnimationController::isEmpty);
        return animationControllers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BakedSkin)) {
            return false;
        }
        BakedSkin that = (BakedSkin)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return Objects.toString(this, "id", this.id, "skin", this.identifier, "type", this.skinType);
    }
}

