/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometrySet;
import moe.plushie.armourers_workshop.core.client.bake.BakedGeometryFace;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenTransform3f;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.core.skin.SkinPreviewData;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryFace;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.geometry.cube.SkinCubeFaceCuller;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTransform;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureModel;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public class BakedGeometryQuads {
    private final HashMap<RenderType, CompressedList<BakedGeometryFace>> splitFaces = new HashMap();
    private final OpenVoxelShape shape;
    private final ColorDescriptor colorInfo;
    private final SkinUsedCounter usedCounter;

    public BakedGeometryQuads(OpenVoxelShape shape, ColorDescriptor colorInfo, SkinUsedCounter usedCounter) {
        this.shape = shape;
        this.colorInfo = colorInfo;
        this.usedCounter = usedCounter;
    }

    public static QuadsList<SkinPartType> from(SkinPart part) {
        QuadsList<SkinPartType> quads = new QuadsList<SkinPartType>();
        ISkinGeometrySet geometries = part.getGeometries();
        OpenVoxelShape shape = ((SkinGeometrySet)geometries).getShape();
        OpenRectangle3i bounds = new OpenRectangle3i(shape.bounds());
        SkinCubeFaceCuller.cullFaces2(geometries, bounds, part.getType()).forEach((? super T result) -> {
            OpenTransform3f newTransform = OpenTransform3f.createTranslateTransform(new OpenVector3f(result.getOrigin()));
            OpenVoxelShape newShape = shape;
            if (result.getPartType() != part.getType()) {
                OpenRectangle3i fixedBounds = result.getBounds().offset(bounds.origin());
                newShape = OpenVoxelShape.box(fixedBounds);
            }
            BakedGeometryQuads newQuads = new BakedGeometryQuads(newShape, new ColorDescriptor(), result.getUsedCounter());
            newQuads.loadFaces(result.getFaces());
            quads.add(result.getPartType(), newTransform, newQuads);
        });
        return quads;
    }

    public static QuadsList<SkinPartType> from(SkinPreviewData previewData) {
        QuadsList<SkinPartType> allQuads = new QuadsList<SkinPartType>();
        if (previewData == null) {
            return allQuads;
        }
        previewData.forEach((ITransform transform, SkinGeometrySet<?> data) -> {
            OpenVoxelShape shape = data.getShape();
            OpenRectangle3i bounds = new OpenRectangle3i(shape.bounds());
            SkinCubeFaceCuller.cullFaces2(data, bounds, SkinPartTypes.BLOCK).forEach((? super T result) -> {
                BakedGeometryQuads quads = new BakedGeometryQuads(shape, new ColorDescriptor(), result.getUsedCounter());
                quads.loadFaces(result.getFaces());
                allQuads.add(result.getPartType(), (ITransform)transform, quads);
            });
        });
        return allQuads;
    }

    public static QuadsList<SkinPartType> from(SkinPaintData paintData) {
        QuadsList<SkinPartType> allQuads = new QuadsList<SkinPartType>();
        if (paintData == null) {
            return allQuads;
        }
        for (Map.Entry<SkinPartType, EntityTextureModel.Box> entry : EntityTextureModel.of(paintData.getWidth(), paintData.getHeight(), false).entrySet()) {
            EntityTextureModel.Box box = entry.getValue();
            ArrayList faces = new ArrayList();
            box.forEach((OpenVector2i texture, int x, int y, int z, OpenDirection dir) -> {
                SkinPaintColor paintColor = SkinPaintColor.of(paintData.getColor(texture));
                if (paintColor.getPaintType() == SkinPaintTypes.NONE) {
                    return;
                }
                int id = dir.get3DDataValue();
                OpenRectangle3f shape = new OpenRectangle3f(x, y, z, 1.0f, 1.0f, 1.0f);
                OpenTransform3f transform = OpenTransform3f.IDENTITY;
                faces.add(new SkinCubeFace(id, SkinGeometryTypes.BLOCK_SOLID, transform, null, shape, dir, paintColor, 255));
            });
            if (faces.isEmpty()) continue;
            BakedGeometryQuads quads = new BakedGeometryQuads(OpenVoxelShape.box(box.getBounds()), new ColorDescriptor(), new SkinUsedCounter());
            quads.loadFaces(faces);
            allQuads.add(entry.getKey(), OpenTransform3f.IDENTITY, quads);
        }
        return allQuads;
    }

    public static BakedGeometryQuads merge(BakedGeometryQuads parent, List<Pair<ITransform, BakedGeometryQuads>> children) {
        if (children.isEmpty()) {
            return parent;
        }
        OpenVoxelShape mergedShape = parent.getShape().copy();
        children.forEach((? super T pair) -> {
            ITransform transform = (ITransform)pair.getKey();
            BakedGeometryQuads child = (BakedGeometryQuads)pair.getValue();
            if (child.getShape().isEmpty()) {
                return;
            }
            OpenVoxelShape shape = child.getShape().copy();
            OpenPoseStack poseStack = new OpenPoseStack();
            transform.apply(poseStack);
            shape.mul(poseStack.last().pose());
            mergedShape.add(shape);
        });
        if (!mergedShape.isEmpty()) {
            mergedShape.optimize();
        }
        BakedGeometryQuads mergedQuads = new BakedGeometryQuads(mergedShape, parent.getColorInfo().copy(), parent.getUsedCounter().copy());
        parent.splitFaces.forEach((? super K key, ? super V value) -> mergedQuads.splitFaces.put((RenderType)key, value.copy()));
        children.forEach((? super T pair) -> {
            ITransform transform = (ITransform)pair.getKey();
            BakedGeometryQuads child = (BakedGeometryQuads)pair.getValue();
            child.splitFaces.forEach((? super K key, ? super V value) -> mergedQuads.splitFaces.computeIfAbsent((RenderType)key, CompressedList::new).addAll(transform, value));
            mergedQuads.getColorInfo().add(child.getColorInfo());
            mergedQuads.getUsedCounter().add(child.getUsedCounter());
        });
        return mergedQuads;
    }

    public void forEach(BiConsumer<RenderType, CompressedList<BakedGeometryFace>> action) {
        this.splitFaces.forEach(action);
    }

    private void loadFaces(Collection<? extends SkinGeometryFace> geometryFaces) {
        for (SkinGeometryFace skinGeometryFace : geometryFaces) {
            if (!skinGeometryFace.isVisible()) continue;
            BakedGeometryFace bakedFace = new BakedGeometryFace(skinGeometryFace);
            this.addSplitFace(bakedFace.getRenderType(), bakedFace);
            if (bakedFace.getRenderTypeVariants() != null) {
                bakedFace.getRenderTypeVariants().forEach((? super T renderType) -> this.addSplitFace((RenderType)renderType, bakedFace));
            }
            if (bakedFace.getDefaultColor() == null) continue;
            this.colorInfo.add(bakedFace.getDefaultColor());
        }
        for (CompressedList compressedList : this.splitFaces.values()) {
            compressedList.sort(Comparator.comparingDouble(BakedGeometryFace::getPriority));
            this.usedCounter.addFaceTotal(compressedList.size());
        }
    }

    private void addSplitFace(RenderType renderType, BakedGeometryFace bakedFace) {
        this.splitFaces.computeIfAbsent(renderType, CompressedList::new).add(bakedFace);
    }

    public SkinUsedCounter getUsedCounter() {
        return this.usedCounter;
    }

    public ColorDescriptor getColorInfo() {
        return this.colorInfo;
    }

    public OpenVoxelShape getShape() {
        return this.shape;
    }

    public static class QuadsList<T> {
        private final ArrayList<Triple<T, ITransform, BakedGeometryQuads>> quads = new ArrayList();

        public void add(T partType, ITransform partTransform, BakedGeometryQuads quad) {
            this.quads.add(Triple.of(partType, (Object)partTransform, (Object)quad));
        }

        public void forEach(QuadsConsumer<T> consumer) {
            this.quads.forEach((Consumer<Triple<T, ITransform, BakedGeometryQuads>>)((Consumer<Triple>)pair -> consumer.accept(pair.getLeft(), (ITransform)pair.getMiddle(), (BakedGeometryQuads)pair.getRight())));
        }
    }

    public static class CompressedList<T> {
        private final RenderType renderType;
        private final ArrayList<T> values = new ArrayList();
        private final ArrayList<Pair<ITransform, List<T>>> transformedValues = new ArrayList();

        public CompressedList(RenderType renderType) {
            this.renderType = renderType;
        }

        public void add(T face) {
            this.values.add(face);
        }

        public void addAll(ITransform transform, CompressedList<T> compressedList) {
            this.transformedValues.add(Pair.of((Object)transform, compressedList.values));
            for (Pair<ITransform, List<T>> transformedValue : compressedList.transformedValues) {
                SkinPartTransform combinedTransform = new SkinPartTransform();
                combinedTransform.addChild(transform);
                combinedTransform.addChild((ITransform)transformedValue.getKey());
                this.transformedValues.add(Pair.of((Object)combinedTransform, (Object)((List)transformedValue.getValue())));
            }
        }

        public void sort(Comparator<? super T> comparator) {
            this.values.sort(comparator);
        }

        public void forEach(BiConsumer<ITransform, List<T>> consumer) {
            consumer.accept(OpenTransform3f.IDENTITY, this.values);
            for (Pair<ITransform, List<T>> transformedValue : this.transformedValues) {
                consumer.accept((ITransform)transformedValue.getLeft(), (List)transformedValue.getValue());
            }
        }

        public int size() {
            int total = this.values.size();
            for (Pair<ITransform, List<T>> transformedValue : this.transformedValues) {
                total += ((List)transformedValue.getValue()).size();
            }
            return total;
        }

        public RenderType renderType() {
            return this.renderType;
        }

        public CompressedList<T> copy() {
            CompressedList<T> list = new CompressedList<T>(this.renderType);
            list.values.addAll(this.values);
            list.transformedValues.addAll(this.transformedValues);
            return list;
        }
    }

    public static interface QuadsConsumer<T> {
        public void accept(T var1, ITransform var2, BakedGeometryQuads var3);
    }
}

