/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointFilter;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;

public class BakedArmature {
    private static final HashMap<Armature, BakedArmature> DEFAULT_IMMUTABLE_ARMATURES = new HashMap();
    private static final HashMap<Armature, BakedArmature> DEFAULT_MUTABLE_ARMATURES = new HashMap();
    private final Armature armature;
    private final IJointTransform[] defaultTransforms;
    private IJointFilter filter;
    private IJointTransform[] finalTransforms;

    public BakedArmature(Armature armature) {
        this.armature = armature;
        this.defaultTransforms = new IJointTransform[armature.size()];
        this.finalTransforms = this.defaultTransforms;
        for (int i = 0; i < this.defaultTransforms.length; ++i) {
            this.defaultTransforms[i] = armature.getGlobalTransform(i);
        }
    }

    public static BakedArmature defaultBy(Armature armature) {
        return DEFAULT_IMMUTABLE_ARMATURES.computeIfAbsent(armature, BakedArmature::new);
    }

    public static BakedArmature defaultBy(SkinType skinType) {
        return BakedArmature.defaultBy(Armatures.byType(skinType));
    }

    public static BakedArmature mutableBy(Armature armature) {
        return DEFAULT_MUTABLE_ARMATURES.computeIfAbsent(armature, BakedArmature::new);
    }

    public static BakedArmature mutableBy(SkinType skinType) {
        return BakedArmature.mutableBy(Armatures.byType(skinType));
    }

    public void setFilter(IJointFilter filter) {
        this.filter = filter;
    }

    public IJointFilter getFilter() {
        return this.filter;
    }

    public IJoint getJoint(SkinPartType partType) {
        IJoint joint = this.armature.getJoint(partType);
        if (joint != null && this.filter != null && !this.filter.test(joint)) {
            return null;
        }
        return joint;
    }

    public IJoint getJoint(BakedSkinPart bakedPart) {
        SkinPartType partType = bakedPart.getType();
        if (partType == SkinPartTypes.BIPPED_LEFT_WING && bakedPart.getProperties().get(SkinProperty.WINGS_MATCHING_POSE).booleanValue()) {
            return this.getJoint(SkinPartTypes.BIPPED_LEFT_PHALANX);
        }
        if (partType == SkinPartTypes.BIPPED_RIGHT_WING && bakedPart.getProperties().get(SkinProperty.WINGS_MATCHING_POSE).booleanValue()) {
            return this.getJoint(SkinPartTypes.BIPPED_RIGHT_PHALANX);
        }
        return this.getJoint(partType);
    }

    public IJointTransform getTransform(IJoint joint) {
        if (joint != null) {
            return this.finalTransforms[joint.getId()];
        }
        return null;
    }

    public IJointTransform getTransform(SkinPartType partType) {
        return this.getTransform(this.getJoint(partType));
    }

    public IJointTransform getTransform(BakedSkinPart bakedPart) {
        IJointTransform transform = this.getTransform(this.getJoint(bakedPart));
        Function<IJointTransform, IJointTransform> transformModifier = bakedPart.getJointTransformModifier();
        if (transformModifier != null) {
            return transformModifier.apply(transform);
        }
        return transform;
    }

    public void seTransforms(IJointTransform[] transforms) {
        this.finalTransforms = transforms != null ? transforms : this.defaultTransforms;
    }

    public IJointTransform[] getTransforms() {
        return this.finalTransforms;
    }

    public Armature getArmature() {
        return this.armature;
    }
}

