/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.animation;

import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.client.animation.AnimationController;
import moe.plushie.armourers_workshop.core.client.animation.AnimationEffectState;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimationLoop;
import moe.plushie.armourers_workshop.core.utils.Objects;

public abstract class AnimationPlayState {
    protected double time = 0.0;
    protected double duration = 0.0;
    protected int loopCount = 0;
    protected double adjustedTime = 0.0;
    protected boolean isCompleted = false;
    protected final Map<String, AnimationEffectState> effects = new HashMap<String, AnimationEffectState>();

    public static AnimationPlayState create(double time, int loopCount, double speed, AnimationController controller) {
        if (loopCount == 0) {
            loopCount = switch (controller.getLoop()) {
                default -> throw new IncompatibleClassChangeError();
                case SkinAnimationLoop.NONE -> 1;
                case SkinAnimationLoop.LAST_FRAME -> 0;
                case SkinAnimationLoop.LOOP -> -1;
            };
        }
        AnimationPlayState playState = AnimationPlayState.createVariant(speed, controller.getDuration());
        playState.setTime(time);
        playState.setDuration(controller.getDuration());
        playState.setLoopCount(loopCount);
        return playState;
    }

    private static AnimationPlayState createVariant(double speed, double duration) {
        if (Double.compare(speed * duration, 0.0) == 0) {
            return new None();
        }
        if (Double.compare(speed, 1.0) == 0) {
            return new Normal();
        }
        return new Modulate(speed);
    }

    protected boolean update(double animationTime) {
        return false;
    }

    protected void reset() {
        this.effects.forEach((name, effectState) -> effectState.reset());
    }

    public void tick(double animationTime) {
        boolean working = this.update(animationTime);
        if (working || this.loopCount == 0) {
            return;
        }
        if (this.loopCount > 0) {
            --this.loopCount;
        }
        if (this.loopCount == 0) {
            this.isCompleted = true;
        }
        this.reset();
    }

    public double getAdjustedTime(double animationTime) {
        if (animationTime < this.time) {
            return 0.0;
        }
        this.tick(animationTime);
        return this.adjustedTime;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public double getTime() {
        return this.time;
    }

    public double getAdjustedTime() {
        return this.adjustedTime;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setLoopCount(int playCount) {
        this.loopCount = playCount;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public AnimationEffectState getEffect(String name) {
        return this.effects.computeIfAbsent(name, AnimationEffectState::new);
    }

    public String toString() {
        return Objects.toString(this, "time", this.time, "duration", this.duration, "loop", this.loopCount, "completed", this.isCompleted);
    }

    private static class None
    extends AnimationPlayState {
        private None() {
        }
    }

    private static class Normal
    extends AnimationPlayState {
        private double lastResetTime = 0.0;

        private Normal() {
        }

        @Override
        protected boolean update(double animationTime) {
            this.adjustedTime = animationTime - this.lastResetTime;
            return this.adjustedTime < this.duration;
        }

        @Override
        protected void reset() {
            super.reset();
            if (this.loopCount != 0) {
                this.lastResetTime += this.duration;
            }
        }

        @Override
        public void setTime(double time) {
            this.time = time;
            this.lastResetTime = time;
        }
    }

    private static class Modulate
    extends AnimationPlayState {
        private double lastResetTime = 0.0;
        private double adjustedDuration = 0.0;
        private final double speed;

        public Modulate(double speed) {
            this.speed = speed;
        }

        @Override
        protected boolean update(double animationTime) {
            double progress = (animationTime - this.lastResetTime) / this.adjustedDuration;
            this.adjustedTime = progress * this.duration;
            return progress < 1.0;
        }

        @Override
        protected void reset() {
            super.reset();
            if (this.loopCount != 0) {
                this.lastResetTime += this.adjustedDuration;
            }
        }

        @Override
        public void setTime(double time) {
            this.time = time;
            this.lastResetTime = time;
        }

        @Override
        public void setDuration(double duration) {
            this.duration = duration;
            this.adjustedDuration = Math.max(duration / this.speed, 1.0E-5);
        }
    }
}

